/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ApiStatus {
    UPDATING("UPDATING"),
    AVAILABLE("AVAILABLE"),
    PENDING("PENDING"),
    FAILED("FAILED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ApiStatus> VALUE_MAP;
    private final String value;

    private ApiStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ApiStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ApiStatus> knownValues() {
        EnumSet<ApiStatus> knownValues = EnumSet.allOf(ApiStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ApiStatus.class, ApiStatus::toString);
    }
}

