/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.apigateway.ApiGatewayClient;
import software.amazon.awssdk.services.apigateway.model.GetUsageRequest;
import software.amazon.awssdk.services.apigateway.model.GetUsageResponse;

public class GetUsageIterable
implements SdkIterable<GetUsageResponse> {
    private final ApiGatewayClient client;
    private final GetUsageRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetUsageIterable(ApiGatewayClient client, GetUsageRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetUsageResponseFetcher();
    }

    public Iterator<GetUsageResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Map.Entry<String, List<List<Long>>>> items() {
        Function<GetUsageResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().entrySet().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final GetUsageIterable resume(GetUsageResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetUsageIterable(this.client, (GetUsageRequest)((Object)this.firstRequest.toBuilder().position(lastSuccessfulPage.position()).build()));
        }
        return new GetUsageIterable(this.client, this.firstRequest){

            @Override
            public Iterator<GetUsageResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class GetUsageResponseFetcher
    implements SyncPageFetcher<GetUsageResponse> {
        private GetUsageResponseFetcher() {
        }

        public boolean hasNextPage(GetUsageResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.position());
        }

        public GetUsageResponse nextPage(GetUsageResponse previousPage) {
            if (previousPage == null) {
                return GetUsageIterable.this.client.getUsage(GetUsageIterable.this.firstRequest);
            }
            return GetUsageIterable.this.client.getUsage((GetUsageRequest)((Object)GetUsageIterable.this.firstRequest.toBuilder().position(previousPage.position()).build()));
        }
    }
}

