/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.apigateway.ApiGatewayClient;
import software.amazon.awssdk.services.apigateway.model.GetModelsRequest;
import software.amazon.awssdk.services.apigateway.model.GetModelsResponse;
import software.amazon.awssdk.services.apigateway.model.Model;

public class GetModelsIterable
implements SdkIterable<GetModelsResponse> {
    private final ApiGatewayClient client;
    private final GetModelsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetModelsIterable(ApiGatewayClient client, GetModelsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetModelsResponseFetcher();
    }

    public Iterator<GetModelsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Model> items() {
        Function<GetModelsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final GetModelsIterable resume(GetModelsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetModelsIterable(this.client, (GetModelsRequest)((Object)this.firstRequest.toBuilder().position(lastSuccessfulPage.position()).build()));
        }
        return new GetModelsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<GetModelsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class GetModelsResponseFetcher
    implements SyncPageFetcher<GetModelsResponse> {
        private GetModelsResponseFetcher() {
        }

        public boolean hasNextPage(GetModelsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.position());
        }

        public GetModelsResponse nextPage(GetModelsResponse previousPage) {
            if (previousPage == null) {
                return GetModelsIterable.this.client.getModels(GetModelsIterable.this.firstRequest);
            }
            return GetModelsIterable.this.client.getModels((GetModelsRequest)((Object)GetModelsIterable.this.firstRequest.toBuilder().position(previousPage.position()).build()));
        }
    }
}

