/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayResponse;
import software.amazon.awssdk.services.apigateway.model.GatewayResponseType;
import software.amazon.awssdk.services.apigateway.model.MapOfStringToStringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetGatewayResponseResponse
extends ApiGatewayResponse
implements ToCopyableBuilder<Builder, GetGatewayResponseResponse> {
    private static final SdkField<String> RESPONSE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("responseType").getter(GetGatewayResponseResponse.getter(GetGatewayResponseResponse::responseTypeAsString)).setter(GetGatewayResponseResponse.setter(Builder::responseType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseType").build()}).build();
    private static final SdkField<String> STATUS_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusCode").getter(GetGatewayResponseResponse.getter(GetGatewayResponseResponse::statusCode)).setter(GetGatewayResponseResponse.setter(Builder::statusCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusCode").build()}).build();
    private static final SdkField<Map<String, String>> RESPONSE_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("responseParameters").getter(GetGatewayResponseResponse.getter(GetGatewayResponseResponse::responseParameters)).setter(GetGatewayResponseResponse.setter(Builder::responseParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> RESPONSE_TEMPLATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("responseTemplates").getter(GetGatewayResponseResponse.getter(GetGatewayResponseResponse::responseTemplates)).setter(GetGatewayResponseResponse.setter(Builder::responseTemplates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseTemplates").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Boolean> DEFAULT_RESPONSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("defaultResponse").getter(GetGatewayResponseResponse.getter(GetGatewayResponseResponse::defaultResponse)).setter(GetGatewayResponseResponse.setter(Builder::defaultResponse)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultResponse").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESPONSE_TYPE_FIELD, STATUS_CODE_FIELD, RESPONSE_PARAMETERS_FIELD, RESPONSE_TEMPLATES_FIELD, DEFAULT_RESPONSE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetGatewayResponseResponse.memberNameToFieldInitializer();
    private final String responseType;
    private final String statusCodeValue;
    private final Map<String, String> responseParameters;
    private final Map<String, String> responseTemplates;
    private final Boolean defaultResponse;

    private GetGatewayResponseResponse(BuilderImpl builder) {
        super(builder);
        this.responseType = builder.responseType;
        this.statusCodeValue = builder.statusCodeValue;
        this.responseParameters = builder.responseParameters;
        this.responseTemplates = builder.responseTemplates;
        this.defaultResponse = builder.defaultResponse;
    }

    public final GatewayResponseType responseType() {
        return GatewayResponseType.fromValue(this.responseType);
    }

    public final String responseTypeAsString() {
        return this.responseType;
    }

    public final String statusCode() {
        return this.statusCodeValue;
    }

    public final boolean hasResponseParameters() {
        return this.responseParameters != null && !(this.responseParameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> responseParameters() {
        return this.responseParameters;
    }

    public final boolean hasResponseTemplates() {
        return this.responseTemplates != null && !(this.responseTemplates instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> responseTemplates() {
        return this.responseTemplates;
    }

    public final Boolean defaultResponse() {
        return this.defaultResponse;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.responseTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResponseParameters() ? this.responseParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResponseTemplates() ? this.responseTemplates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultResponse());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetGatewayResponseResponse)) {
            return false;
        }
        GetGatewayResponseResponse other = (GetGatewayResponseResponse)((Object)obj);
        return Objects.equals(this.responseTypeAsString(), other.responseTypeAsString()) && Objects.equals(this.statusCode(), other.statusCode()) && this.hasResponseParameters() == other.hasResponseParameters() && Objects.equals(this.responseParameters(), other.responseParameters()) && this.hasResponseTemplates() == other.hasResponseTemplates() && Objects.equals(this.responseTemplates(), other.responseTemplates()) && Objects.equals(this.defaultResponse(), other.defaultResponse());
    }

    public final String toString() {
        return ToString.builder((String)"GetGatewayResponseResponse").add("ResponseType", (Object)this.responseTypeAsString()).add("StatusCode", (Object)this.statusCode()).add("ResponseParameters", this.hasResponseParameters() ? this.responseParameters() : null).add("ResponseTemplates", this.hasResponseTemplates() ? this.responseTemplates() : null).add("DefaultResponse", (Object)this.defaultResponse()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "responseType": {
                return Optional.ofNullable(clazz.cast(this.responseTypeAsString()));
            }
            case "statusCode": {
                return Optional.ofNullable(clazz.cast(this.statusCode()));
            }
            case "responseParameters": {
                return Optional.ofNullable(clazz.cast(this.responseParameters()));
            }
            case "responseTemplates": {
                return Optional.ofNullable(clazz.cast(this.responseTemplates()));
            }
            case "defaultResponse": {
                return Optional.ofNullable(clazz.cast(this.defaultResponse()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("responseType", RESPONSE_TYPE_FIELD);
        map.put("statusCode", STATUS_CODE_FIELD);
        map.put("responseParameters", RESPONSE_PARAMETERS_FIELD);
        map.put("responseTemplates", RESPONSE_TEMPLATES_FIELD);
        map.put("defaultResponse", DEFAULT_RESPONSE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetGatewayResponseResponse, T> g) {
        return obj -> g.apply((GetGatewayResponseResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayResponse.BuilderImpl
    implements Builder {
        private String responseType;
        private String statusCodeValue;
        private Map<String, String> responseParameters = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> responseTemplates = DefaultSdkAutoConstructMap.getInstance();
        private Boolean defaultResponse;

        private BuilderImpl() {
        }

        private BuilderImpl(GetGatewayResponseResponse model) {
            super(model);
            this.responseType(model.responseType);
            this.statusCode(model.statusCodeValue);
            this.responseParameters(model.responseParameters);
            this.responseTemplates(model.responseTemplates);
            this.defaultResponse(model.defaultResponse);
        }

        public final String getResponseType() {
            return this.responseType;
        }

        public final void setResponseType(String responseType) {
            this.responseType = responseType;
        }

        @Override
        public final Builder responseType(String responseType) {
            this.responseType = responseType;
            return this;
        }

        @Override
        public final Builder responseType(GatewayResponseType responseType) {
            this.responseType(responseType == null ? null : responseType.toString());
            return this;
        }

        public final String getStatusCode() {
            return this.statusCodeValue;
        }

        public final void setStatusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
        }

        @Override
        public final Builder statusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
            return this;
        }

        public final Map<String, String> getResponseParameters() {
            if (this.responseParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.responseParameters;
        }

        public final void setResponseParameters(Map<String, String> responseParameters) {
            this.responseParameters = MapOfStringToStringCopier.copy(responseParameters);
        }

        @Override
        public final Builder responseParameters(Map<String, String> responseParameters) {
            this.responseParameters = MapOfStringToStringCopier.copy(responseParameters);
            return this;
        }

        public final Map<String, String> getResponseTemplates() {
            if (this.responseTemplates instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.responseTemplates;
        }

        public final void setResponseTemplates(Map<String, String> responseTemplates) {
            this.responseTemplates = MapOfStringToStringCopier.copy(responseTemplates);
        }

        @Override
        public final Builder responseTemplates(Map<String, String> responseTemplates) {
            this.responseTemplates = MapOfStringToStringCopier.copy(responseTemplates);
            return this;
        }

        public final Boolean getDefaultResponse() {
            return this.defaultResponse;
        }

        public final void setDefaultResponse(Boolean defaultResponse) {
            this.defaultResponse = defaultResponse;
        }

        @Override
        public final Builder defaultResponse(Boolean defaultResponse) {
            this.defaultResponse = defaultResponse;
            return this;
        }

        @Override
        public GetGatewayResponseResponse build() {
            return new GetGatewayResponseResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ApiGatewayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetGatewayResponseResponse> {
        public Builder responseType(String var1);

        public Builder responseType(GatewayResponseType var1);

        public Builder statusCode(String var1);

        public Builder responseParameters(Map<String, String> var1);

        public Builder responseTemplates(Map<String, String> var1);

        public Builder defaultResponse(Boolean var1);
    }
}

