/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateBasePathMappingRequest
extends ApiGatewayRequest
implements ToCopyableBuilder<Builder, CreateBasePathMappingRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainName").getter(CreateBasePathMappingRequest.getter(CreateBasePathMappingRequest::domainName)).setter(CreateBasePathMappingRequest.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("domain_name").build()}).build();
    private static final SdkField<String> DOMAIN_NAME_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainNameId").getter(CreateBasePathMappingRequest.getter(CreateBasePathMappingRequest::domainNameId)).setter(CreateBasePathMappingRequest.setter(Builder::domainNameId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("domainNameId").build()}).build();
    private static final SdkField<String> BASE_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("basePath").getter(CreateBasePathMappingRequest.getter(CreateBasePathMappingRequest::basePath)).setter(CreateBasePathMappingRequest.setter(Builder::basePath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("basePath").build()}).build();
    private static final SdkField<String> REST_API_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("restApiId").getter(CreateBasePathMappingRequest.getter(CreateBasePathMappingRequest::restApiId)).setter(CreateBasePathMappingRequest.setter(Builder::restApiId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("restApiId").build()}).build();
    private static final SdkField<String> STAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stage").getter(CreateBasePathMappingRequest.getter(CreateBasePathMappingRequest::stage)).setter(CreateBasePathMappingRequest.setter(Builder::stage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, DOMAIN_NAME_ID_FIELD, BASE_PATH_FIELD, REST_API_ID_FIELD, STAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("domain_name", DOMAIN_NAME_FIELD);
            this.put("domainNameId", DOMAIN_NAME_ID_FIELD);
            this.put("basePath", BASE_PATH_FIELD);
            this.put("restApiId", REST_API_ID_FIELD);
            this.put("stage", STAGE_FIELD);
        }
    });
    private final String domainName;
    private final String domainNameId;
    private final String basePath;
    private final String restApiId;
    private final String stage;

    private CreateBasePathMappingRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.domainNameId = builder.domainNameId;
        this.basePath = builder.basePath;
        this.restApiId = builder.restApiId;
        this.stage = builder.stage;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final String domainNameId() {
        return this.domainNameId;
    }

    public final String basePath() {
        return this.basePath;
    }

    public final String restApiId() {
        return this.restApiId;
    }

    public final String stage() {
        return this.stage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainNameId());
        hashCode = 31 * hashCode + Objects.hashCode(this.basePath());
        hashCode = 31 * hashCode + Objects.hashCode(this.restApiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBasePathMappingRequest)) {
            return false;
        }
        CreateBasePathMappingRequest other = (CreateBasePathMappingRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.domainNameId(), other.domainNameId()) && Objects.equals(this.basePath(), other.basePath()) && Objects.equals(this.restApiId(), other.restApiId()) && Objects.equals(this.stage(), other.stage());
    }

    public final String toString() {
        return ToString.builder((String)"CreateBasePathMappingRequest").add("DomainName", (Object)this.domainName()).add("DomainNameId", (Object)this.domainNameId()).add("BasePath", (Object)this.basePath()).add("RestApiId", (Object)this.restApiId()).add("Stage", (Object)this.stage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "domainNameId": {
                return Optional.ofNullable(clazz.cast(this.domainNameId()));
            }
            case "basePath": {
                return Optional.ofNullable(clazz.cast(this.basePath()));
            }
            case "restApiId": {
                return Optional.ofNullable(clazz.cast(this.restApiId()));
            }
            case "stage": {
                return Optional.ofNullable(clazz.cast(this.stage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateBasePathMappingRequest, T> g) {
        return obj -> g.apply((CreateBasePathMappingRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayRequest.BuilderImpl
    implements Builder {
        private String domainName;
        private String domainNameId;
        private String basePath;
        private String restApiId;
        private String stage;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBasePathMappingRequest model) {
            super(model);
            this.domainName(model.domainName);
            this.domainNameId(model.domainNameId);
            this.basePath(model.basePath);
            this.restApiId(model.restApiId);
            this.stage(model.stage);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getDomainNameId() {
            return this.domainNameId;
        }

        public final void setDomainNameId(String domainNameId) {
            this.domainNameId = domainNameId;
        }

        @Override
        public final Builder domainNameId(String domainNameId) {
            this.domainNameId = domainNameId;
            return this;
        }

        public final String getBasePath() {
            return this.basePath;
        }

        public final void setBasePath(String basePath) {
            this.basePath = basePath;
        }

        @Override
        public final Builder basePath(String basePath) {
            this.basePath = basePath;
            return this;
        }

        public final String getRestApiId() {
            return this.restApiId;
        }

        public final void setRestApiId(String restApiId) {
            this.restApiId = restApiId;
        }

        @Override
        public final Builder restApiId(String restApiId) {
            this.restApiId = restApiId;
            return this;
        }

        public final String getStage() {
            return this.stage;
        }

        public final void setStage(String stage) {
            this.stage = stage;
        }

        @Override
        public final Builder stage(String stage) {
            this.stage = stage;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateBasePathMappingRequest build() {
            return new CreateBasePathMappingRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ApiGatewayRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateBasePathMappingRequest> {
        public Builder domainName(String var1);

        public Builder domainNameId(String var1);

        public Builder basePath(String var1);

        public Builder restApiId(String var1);

        public Builder stage(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

