/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayRequest;
import software.amazon.awssdk.services.apigateway.model.ApiKeySourceType;
import software.amazon.awssdk.services.apigateway.model.EndpointConfiguration;
import software.amazon.awssdk.services.apigateway.model.ListOfStringCopier;
import software.amazon.awssdk.services.apigateway.model.MapOfStringToStringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateRestApiRequest
extends ApiGatewayRequest
implements ToCopyableBuilder<Builder, CreateRestApiRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateRestApiRequest.getter(CreateRestApiRequest::name)).setter(CreateRestApiRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateRestApiRequest.getter(CreateRestApiRequest::description)).setter(CreateRestApiRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("version").getter(CreateRestApiRequest.getter(CreateRestApiRequest::version)).setter(CreateRestApiRequest.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final SdkField<String> CLONE_FROM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cloneFrom").getter(CreateRestApiRequest.getter(CreateRestApiRequest::cloneFrom)).setter(CreateRestApiRequest.setter(Builder::cloneFrom)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloneFrom").build()}).build();
    private static final SdkField<List<String>> BINARY_MEDIA_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("binaryMediaTypes").getter(CreateRestApiRequest.getter(CreateRestApiRequest::binaryMediaTypes)).setter(CreateRestApiRequest.setter(Builder::binaryMediaTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("binaryMediaTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MINIMUM_COMPRESSION_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("minimumCompressionSize").getter(CreateRestApiRequest.getter(CreateRestApiRequest::minimumCompressionSize)).setter(CreateRestApiRequest.setter(Builder::minimumCompressionSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minimumCompressionSize").build()}).build();
    private static final SdkField<String> API_KEY_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("apiKeySource").getter(CreateRestApiRequest.getter(CreateRestApiRequest::apiKeySourceAsString)).setter(CreateRestApiRequest.setter(Builder::apiKeySource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiKeySource").build()}).build();
    private static final SdkField<EndpointConfiguration> ENDPOINT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("endpointConfiguration").getter(CreateRestApiRequest.getter(CreateRestApiRequest::endpointConfiguration)).setter(CreateRestApiRequest.setter(Builder::endpointConfiguration)).constructor(EndpointConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpointConfiguration").build()}).build();
    private static final SdkField<String> POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policy").getter(CreateRestApiRequest.getter(CreateRestApiRequest::policy)).setter(CreateRestApiRequest.setter(Builder::policy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policy").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateRestApiRequest.getter(CreateRestApiRequest::tags)).setter(CreateRestApiRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Boolean> DISABLE_EXECUTE_API_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("disableExecuteApiEndpoint").getter(CreateRestApiRequest.getter(CreateRestApiRequest::disableExecuteApiEndpoint)).setter(CreateRestApiRequest.setter(Builder::disableExecuteApiEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("disableExecuteApiEndpoint").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, VERSION_FIELD, CLONE_FROM_FIELD, BINARY_MEDIA_TYPES_FIELD, MINIMUM_COMPRESSION_SIZE_FIELD, API_KEY_SOURCE_FIELD, ENDPOINT_CONFIGURATION_FIELD, POLICY_FIELD, TAGS_FIELD, DISABLE_EXECUTE_API_ENDPOINT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("name", NAME_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("version", VERSION_FIELD);
            this.put("cloneFrom", CLONE_FROM_FIELD);
            this.put("binaryMediaTypes", BINARY_MEDIA_TYPES_FIELD);
            this.put("minimumCompressionSize", MINIMUM_COMPRESSION_SIZE_FIELD);
            this.put("apiKeySource", API_KEY_SOURCE_FIELD);
            this.put("endpointConfiguration", ENDPOINT_CONFIGURATION_FIELD);
            this.put("policy", POLICY_FIELD);
            this.put("tags", TAGS_FIELD);
            this.put("disableExecuteApiEndpoint", DISABLE_EXECUTE_API_ENDPOINT_FIELD);
        }
    });
    private final String name;
    private final String description;
    private final String version;
    private final String cloneFrom;
    private final List<String> binaryMediaTypes;
    private final Integer minimumCompressionSize;
    private final String apiKeySource;
    private final EndpointConfiguration endpointConfiguration;
    private final String policy;
    private final Map<String, String> tags;
    private final Boolean disableExecuteApiEndpoint;

    private CreateRestApiRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.version = builder.version;
        this.cloneFrom = builder.cloneFrom;
        this.binaryMediaTypes = builder.binaryMediaTypes;
        this.minimumCompressionSize = builder.minimumCompressionSize;
        this.apiKeySource = builder.apiKeySource;
        this.endpointConfiguration = builder.endpointConfiguration;
        this.policy = builder.policy;
        this.tags = builder.tags;
        this.disableExecuteApiEndpoint = builder.disableExecuteApiEndpoint;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String version() {
        return this.version;
    }

    public final String cloneFrom() {
        return this.cloneFrom;
    }

    public final boolean hasBinaryMediaTypes() {
        return this.binaryMediaTypes != null && !(this.binaryMediaTypes instanceof SdkAutoConstructList);
    }

    public final List<String> binaryMediaTypes() {
        return this.binaryMediaTypes;
    }

    public final Integer minimumCompressionSize() {
        return this.minimumCompressionSize;
    }

    public final ApiKeySourceType apiKeySource() {
        return ApiKeySourceType.fromValue(this.apiKeySource);
    }

    public final String apiKeySourceAsString() {
        return this.apiKeySource;
    }

    public final EndpointConfiguration endpointConfiguration() {
        return this.endpointConfiguration;
    }

    public final String policy() {
        return this.policy;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final Boolean disableExecuteApiEndpoint() {
        return this.disableExecuteApiEndpoint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloneFrom());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBinaryMediaTypes() ? this.binaryMediaTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.minimumCompressionSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.apiKeySourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.policy());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.disableExecuteApiEndpoint());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRestApiRequest)) {
            return false;
        }
        CreateRestApiRequest other = (CreateRestApiRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.cloneFrom(), other.cloneFrom()) && this.hasBinaryMediaTypes() == other.hasBinaryMediaTypes() && Objects.equals(this.binaryMediaTypes(), other.binaryMediaTypes()) && Objects.equals(this.minimumCompressionSize(), other.minimumCompressionSize()) && Objects.equals(this.apiKeySourceAsString(), other.apiKeySourceAsString()) && Objects.equals(this.endpointConfiguration(), other.endpointConfiguration()) && Objects.equals(this.policy(), other.policy()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.disableExecuteApiEndpoint(), other.disableExecuteApiEndpoint());
    }

    public final String toString() {
        return ToString.builder((String)"CreateRestApiRequest").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Version", (Object)this.version()).add("CloneFrom", (Object)this.cloneFrom()).add("BinaryMediaTypes", this.hasBinaryMediaTypes() ? this.binaryMediaTypes() : null).add("MinimumCompressionSize", (Object)this.minimumCompressionSize()).add("ApiKeySource", (Object)this.apiKeySourceAsString()).add("EndpointConfiguration", (Object)this.endpointConfiguration()).add("Policy", (Object)this.policy()).add("Tags", this.hasTags() ? this.tags() : null).add("DisableExecuteApiEndpoint", (Object)this.disableExecuteApiEndpoint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "cloneFrom": {
                return Optional.ofNullable(clazz.cast(this.cloneFrom()));
            }
            case "binaryMediaTypes": {
                return Optional.ofNullable(clazz.cast(this.binaryMediaTypes()));
            }
            case "minimumCompressionSize": {
                return Optional.ofNullable(clazz.cast(this.minimumCompressionSize()));
            }
            case "apiKeySource": {
                return Optional.ofNullable(clazz.cast(this.apiKeySourceAsString()));
            }
            case "endpointConfiguration": {
                return Optional.ofNullable(clazz.cast(this.endpointConfiguration()));
            }
            case "policy": {
                return Optional.ofNullable(clazz.cast(this.policy()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "disableExecuteApiEndpoint": {
                return Optional.ofNullable(clazz.cast(this.disableExecuteApiEndpoint()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateRestApiRequest, T> g) {
        return obj -> g.apply((CreateRestApiRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayRequest.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String version;
        private String cloneFrom;
        private List<String> binaryMediaTypes = DefaultSdkAutoConstructList.getInstance();
        private Integer minimumCompressionSize;
        private String apiKeySource;
        private EndpointConfiguration endpointConfiguration;
        private String policy;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private Boolean disableExecuteApiEndpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRestApiRequest model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.version(model.version);
            this.cloneFrom(model.cloneFrom);
            this.binaryMediaTypes(model.binaryMediaTypes);
            this.minimumCompressionSize(model.minimumCompressionSize);
            this.apiKeySource(model.apiKeySource);
            this.endpointConfiguration(model.endpointConfiguration);
            this.policy(model.policy);
            this.tags(model.tags);
            this.disableExecuteApiEndpoint(model.disableExecuteApiEndpoint);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final String getCloneFrom() {
            return this.cloneFrom;
        }

        public final void setCloneFrom(String cloneFrom) {
            this.cloneFrom = cloneFrom;
        }

        @Override
        public final Builder cloneFrom(String cloneFrom) {
            this.cloneFrom = cloneFrom;
            return this;
        }

        public final Collection<String> getBinaryMediaTypes() {
            if (this.binaryMediaTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.binaryMediaTypes;
        }

        public final void setBinaryMediaTypes(Collection<String> binaryMediaTypes) {
            this.binaryMediaTypes = ListOfStringCopier.copy(binaryMediaTypes);
        }

        @Override
        public final Builder binaryMediaTypes(Collection<String> binaryMediaTypes) {
            this.binaryMediaTypes = ListOfStringCopier.copy(binaryMediaTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder binaryMediaTypes(String ... binaryMediaTypes) {
            this.binaryMediaTypes(Arrays.asList(binaryMediaTypes));
            return this;
        }

        public final Integer getMinimumCompressionSize() {
            return this.minimumCompressionSize;
        }

        public final void setMinimumCompressionSize(Integer minimumCompressionSize) {
            this.minimumCompressionSize = minimumCompressionSize;
        }

        @Override
        public final Builder minimumCompressionSize(Integer minimumCompressionSize) {
            this.minimumCompressionSize = minimumCompressionSize;
            return this;
        }

        public final String getApiKeySource() {
            return this.apiKeySource;
        }

        public final void setApiKeySource(String apiKeySource) {
            this.apiKeySource = apiKeySource;
        }

        @Override
        public final Builder apiKeySource(String apiKeySource) {
            this.apiKeySource = apiKeySource;
            return this;
        }

        @Override
        public final Builder apiKeySource(ApiKeySourceType apiKeySource) {
            this.apiKeySource(apiKeySource == null ? null : apiKeySource.toString());
            return this;
        }

        public final EndpointConfiguration.Builder getEndpointConfiguration() {
            return this.endpointConfiguration != null ? this.endpointConfiguration.toBuilder() : null;
        }

        public final void setEndpointConfiguration(EndpointConfiguration.BuilderImpl endpointConfiguration) {
            this.endpointConfiguration = endpointConfiguration != null ? endpointConfiguration.build() : null;
        }

        @Override
        public final Builder endpointConfiguration(EndpointConfiguration endpointConfiguration) {
            this.endpointConfiguration = endpointConfiguration;
            return this;
        }

        public final String getPolicy() {
            return this.policy;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        @Override
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = MapOfStringToStringCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = MapOfStringToStringCopier.copy(tags);
            return this;
        }

        public final Boolean getDisableExecuteApiEndpoint() {
            return this.disableExecuteApiEndpoint;
        }

        public final void setDisableExecuteApiEndpoint(Boolean disableExecuteApiEndpoint) {
            this.disableExecuteApiEndpoint = disableExecuteApiEndpoint;
        }

        @Override
        public final Builder disableExecuteApiEndpoint(Boolean disableExecuteApiEndpoint) {
            this.disableExecuteApiEndpoint = disableExecuteApiEndpoint;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRestApiRequest build() {
            return new CreateRestApiRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ApiGatewayRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateRestApiRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder version(String var1);

        public Builder cloneFrom(String var1);

        public Builder binaryMediaTypes(Collection<String> var1);

        public Builder binaryMediaTypes(String ... var1);

        public Builder minimumCompressionSize(Integer var1);

        public Builder apiKeySource(String var1);

        public Builder apiKeySource(ApiKeySourceType var1);

        public Builder endpointConfiguration(EndpointConfiguration var1);

        default public Builder endpointConfiguration(Consumer<EndpointConfiguration.Builder> endpointConfiguration) {
            return this.endpointConfiguration((EndpointConfiguration)((EndpointConfiguration.Builder)EndpointConfiguration.builder().applyMutation(endpointConfiguration)).build());
        }

        public Builder policy(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder disableExecuteApiEndpoint(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

