/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.apigateway.ApiGatewayAsyncClient;
import software.amazon.awssdk.services.apigateway.model.ClientCertificate;
import software.amazon.awssdk.services.apigateway.model.GetClientCertificatesRequest;
import software.amazon.awssdk.services.apigateway.model.GetClientCertificatesResponse;

public class GetClientCertificatesPublisher
implements SdkPublisher<GetClientCertificatesResponse> {
    private final ApiGatewayAsyncClient client;
    private final GetClientCertificatesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetClientCertificatesPublisher(ApiGatewayAsyncClient client, GetClientCertificatesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetClientCertificatesPublisher(ApiGatewayAsyncClient client, GetClientCertificatesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetClientCertificatesResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetClientCertificatesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ClientCertificate> items() {
        Function<GetClientCertificatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetClientCertificatesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetClientCertificatesResponseFetcher
    implements AsyncPageFetcher<GetClientCertificatesResponse> {
        private GetClientCertificatesResponseFetcher() {
        }

        public boolean hasNextPage(GetClientCertificatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.position());
        }

        public CompletableFuture<GetClientCertificatesResponse> nextPage(GetClientCertificatesResponse previousPage) {
            if (previousPage == null) {
                return GetClientCertificatesPublisher.this.client.getClientCertificates(GetClientCertificatesPublisher.this.firstRequest);
            }
            return GetClientCertificatesPublisher.this.client.getClientCertificates((GetClientCertificatesRequest)((Object)GetClientCertificatesPublisher.this.firstRequest.toBuilder().position(previousPage.position()).build()));
        }
    }
}

