/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayRequest;
import software.amazon.awssdk.services.apigateway.model.MapOfHeaderValuesCopier;
import software.amazon.awssdk.services.apigateway.model.MapOfStringToStringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TestInvokeAuthorizerRequest
extends ApiGatewayRequest
implements ToCopyableBuilder<Builder, TestInvokeAuthorizerRequest> {
    private static final SdkField<String> REST_API_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TestInvokeAuthorizerRequest.getter(TestInvokeAuthorizerRequest::restApiId)).setter(TestInvokeAuthorizerRequest.setter(Builder::restApiId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("restapi_id").build()}).build();
    private static final SdkField<String> AUTHORIZER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TestInvokeAuthorizerRequest.getter(TestInvokeAuthorizerRequest::authorizerId)).setter(TestInvokeAuthorizerRequest.setter(Builder::authorizerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("authorizer_id").build()}).build();
    private static final SdkField<Map<String, String>> HEADERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(TestInvokeAuthorizerRequest.getter(TestInvokeAuthorizerRequest::headers)).setter(TestInvokeAuthorizerRequest.setter(Builder::headers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("headers").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> PATH_WITH_QUERY_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TestInvokeAuthorizerRequest.getter(TestInvokeAuthorizerRequest::pathWithQueryString)).setter(TestInvokeAuthorizerRequest.setter(Builder::pathWithQueryString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pathWithQueryString").build()}).build();
    private static final SdkField<String> BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TestInvokeAuthorizerRequest.getter(TestInvokeAuthorizerRequest::body)).setter(TestInvokeAuthorizerRequest.setter(Builder::body)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("body").build()}).build();
    private static final SdkField<Map<String, String>> STAGE_VARIABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(TestInvokeAuthorizerRequest.getter(TestInvokeAuthorizerRequest::stageVariables)).setter(TestInvokeAuthorizerRequest.setter(Builder::stageVariables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stageVariables").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> ADDITIONAL_CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(TestInvokeAuthorizerRequest.getter(TestInvokeAuthorizerRequest::additionalContext)).setter(TestInvokeAuthorizerRequest.setter(Builder::additionalContext)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalContext").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REST_API_ID_FIELD, AUTHORIZER_ID_FIELD, HEADERS_FIELD, PATH_WITH_QUERY_STRING_FIELD, BODY_FIELD, STAGE_VARIABLES_FIELD, ADDITIONAL_CONTEXT_FIELD));
    private final String restApiId;
    private final String authorizerId;
    private final Map<String, String> headers;
    private final String pathWithQueryString;
    private final String body;
    private final Map<String, String> stageVariables;
    private final Map<String, String> additionalContext;

    private TestInvokeAuthorizerRequest(BuilderImpl builder) {
        super(builder);
        this.restApiId = builder.restApiId;
        this.authorizerId = builder.authorizerId;
        this.headers = builder.headers;
        this.pathWithQueryString = builder.pathWithQueryString;
        this.body = builder.body;
        this.stageVariables = builder.stageVariables;
        this.additionalContext = builder.additionalContext;
    }

    public String restApiId() {
        return this.restApiId;
    }

    public String authorizerId() {
        return this.authorizerId;
    }

    public Map<String, String> headers() {
        return this.headers;
    }

    public String pathWithQueryString() {
        return this.pathWithQueryString;
    }

    public String body() {
        return this.body;
    }

    public Map<String, String> stageVariables() {
        return this.stageVariables;
    }

    public Map<String, String> additionalContext() {
        return this.additionalContext;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.restApiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.headers());
        hashCode = 31 * hashCode + Objects.hashCode(this.pathWithQueryString());
        hashCode = 31 * hashCode + Objects.hashCode(this.body());
        hashCode = 31 * hashCode + Objects.hashCode(this.stageVariables());
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalContext());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestInvokeAuthorizerRequest)) {
            return false;
        }
        TestInvokeAuthorizerRequest other = (TestInvokeAuthorizerRequest)((Object)obj);
        return Objects.equals(this.restApiId(), other.restApiId()) && Objects.equals(this.authorizerId(), other.authorizerId()) && Objects.equals(this.headers(), other.headers()) && Objects.equals(this.pathWithQueryString(), other.pathWithQueryString()) && Objects.equals(this.body(), other.body()) && Objects.equals(this.stageVariables(), other.stageVariables()) && Objects.equals(this.additionalContext(), other.additionalContext());
    }

    public String toString() {
        return ToString.builder((String)"TestInvokeAuthorizerRequest").add("RestApiId", (Object)this.restApiId()).add("AuthorizerId", (Object)this.authorizerId()).add("Headers", this.headers()).add("PathWithQueryString", (Object)this.pathWithQueryString()).add("Body", (Object)this.body()).add("StageVariables", this.stageVariables()).add("AdditionalContext", this.additionalContext()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "restApiId": {
                return Optional.ofNullable(clazz.cast(this.restApiId()));
            }
            case "authorizerId": {
                return Optional.ofNullable(clazz.cast(this.authorizerId()));
            }
            case "headers": {
                return Optional.ofNullable(clazz.cast(this.headers()));
            }
            case "pathWithQueryString": {
                return Optional.ofNullable(clazz.cast(this.pathWithQueryString()));
            }
            case "body": {
                return Optional.ofNullable(clazz.cast(this.body()));
            }
            case "stageVariables": {
                return Optional.ofNullable(clazz.cast(this.stageVariables()));
            }
            case "additionalContext": {
                return Optional.ofNullable(clazz.cast(this.additionalContext()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TestInvokeAuthorizerRequest, T> g) {
        return obj -> g.apply((TestInvokeAuthorizerRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayRequest.BuilderImpl
    implements Builder {
        private String restApiId;
        private String authorizerId;
        private Map<String, String> headers = DefaultSdkAutoConstructMap.getInstance();
        private String pathWithQueryString;
        private String body;
        private Map<String, String> stageVariables = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> additionalContext = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TestInvokeAuthorizerRequest model) {
            super(model);
            this.restApiId(model.restApiId);
            this.authorizerId(model.authorizerId);
            this.headers(model.headers);
            this.pathWithQueryString(model.pathWithQueryString);
            this.body(model.body);
            this.stageVariables(model.stageVariables);
            this.additionalContext(model.additionalContext);
        }

        public final String getRestApiId() {
            return this.restApiId;
        }

        @Override
        public final Builder restApiId(String restApiId) {
            this.restApiId = restApiId;
            return this;
        }

        public final void setRestApiId(String restApiId) {
            this.restApiId = restApiId;
        }

        public final String getAuthorizerId() {
            return this.authorizerId;
        }

        @Override
        public final Builder authorizerId(String authorizerId) {
            this.authorizerId = authorizerId;
            return this;
        }

        public final void setAuthorizerId(String authorizerId) {
            this.authorizerId = authorizerId;
        }

        public final Map<String, String> getHeaders() {
            return this.headers;
        }

        @Override
        public final Builder headers(Map<String, String> headers) {
            this.headers = MapOfHeaderValuesCopier.copy(headers);
            return this;
        }

        public final void setHeaders(Map<String, String> headers) {
            this.headers = MapOfHeaderValuesCopier.copy(headers);
        }

        public final String getPathWithQueryString() {
            return this.pathWithQueryString;
        }

        @Override
        public final Builder pathWithQueryString(String pathWithQueryString) {
            this.pathWithQueryString = pathWithQueryString;
            return this;
        }

        public final void setPathWithQueryString(String pathWithQueryString) {
            this.pathWithQueryString = pathWithQueryString;
        }

        public final String getBody() {
            return this.body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        public final Map<String, String> getStageVariables() {
            return this.stageVariables;
        }

        @Override
        public final Builder stageVariables(Map<String, String> stageVariables) {
            this.stageVariables = MapOfStringToStringCopier.copy(stageVariables);
            return this;
        }

        public final void setStageVariables(Map<String, String> stageVariables) {
            this.stageVariables = MapOfStringToStringCopier.copy(stageVariables);
        }

        public final Map<String, String> getAdditionalContext() {
            return this.additionalContext;
        }

        @Override
        public final Builder additionalContext(Map<String, String> additionalContext) {
            this.additionalContext = MapOfStringToStringCopier.copy(additionalContext);
            return this;
        }

        public final void setAdditionalContext(Map<String, String> additionalContext) {
            this.additionalContext = MapOfStringToStringCopier.copy(additionalContext);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TestInvokeAuthorizerRequest build() {
            return new TestInvokeAuthorizerRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApiGatewayRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, TestInvokeAuthorizerRequest> {
        public Builder restApiId(String var1);

        public Builder authorizerId(String var1);

        public Builder headers(Map<String, String> var1);

        public Builder pathWithQueryString(String var1);

        public Builder body(String var1);

        public Builder stageVariables(Map<String, String> var1);

        public Builder additionalContext(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

