/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.apigateway.model.UsagePlan;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class UsagePlanMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("id").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").isBinary(false).build();
    private static final MarshallingInfo<List> APISTAGES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("apiStages").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> THROTTLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("throttle").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> QUOTA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("quota").isBinary(false).build();
    private static final MarshallingInfo<String> PRODUCTCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("productCode").isBinary(false).build();
    private static final UsagePlanMarshaller INSTANCE = new UsagePlanMarshaller();

    private UsagePlanMarshaller() {
    }

    public static UsagePlanMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UsagePlan usagePlan, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)usagePlan, (String)"usagePlan");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)usagePlan.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)usagePlan.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)usagePlan.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(usagePlan.apiStages(), APISTAGES_BINDING);
            protocolMarshaller.marshall((Object)usagePlan.throttle(), THROTTLE_BINDING);
            protocolMarshaller.marshall((Object)usagePlan.quota(), QUOTA_BINDING);
            protocolMarshaller.marshall((Object)usagePlan.productCode(), PRODUCTCODE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

