/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.apigateway.model.UpdateApiKeyRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class UpdateApiKeyRequestModelMarshaller {
    private static final MarshallingInfo<String> APIKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("api_Key").isBinary(false).build();
    private static final MarshallingInfo<List> PATCHOPERATIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("patchOperations").isBinary(false).build();
    private static final UpdateApiKeyRequestModelMarshaller INSTANCE = new UpdateApiKeyRequestModelMarshaller();

    private UpdateApiKeyRequestModelMarshaller() {
    }

    public static UpdateApiKeyRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UpdateApiKeyRequest updateApiKeyRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)updateApiKeyRequest), (String)"updateApiKeyRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)updateApiKeyRequest.apiKey(), APIKEY_BINDING);
            protocolMarshaller.marshall(updateApiKeyRequest.patchOperations(), PATCHOPERATIONS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

