/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.apigateway.model.TestInvokeAuthorizerRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class TestInvokeAuthorizerRequestModelMarshaller {
    private static final MarshallingInfo<String> RESTAPIID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("restapi_id").isBinary(false).build();
    private static final MarshallingInfo<String> AUTHORIZERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("authorizer_id").isBinary(false).build();
    private static final MarshallingInfo<Map> HEADERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("headers").isBinary(false).build();
    private static final MarshallingInfo<String> PATHWITHQUERYSTRING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("pathWithQueryString").isBinary(false).build();
    private static final MarshallingInfo<String> BODY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("body").isBinary(false).build();
    private static final MarshallingInfo<Map> STAGEVARIABLES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stageVariables").isBinary(false).build();
    private static final MarshallingInfo<Map> ADDITIONALCONTEXT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("additionalContext").isBinary(false).build();
    private static final TestInvokeAuthorizerRequestModelMarshaller INSTANCE = new TestInvokeAuthorizerRequestModelMarshaller();

    private TestInvokeAuthorizerRequestModelMarshaller() {
    }

    public static TestInvokeAuthorizerRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(TestInvokeAuthorizerRequest testInvokeAuthorizerRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)testInvokeAuthorizerRequest), (String)"testInvokeAuthorizerRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)testInvokeAuthorizerRequest.restApiId(), RESTAPIID_BINDING);
            protocolMarshaller.marshall((Object)testInvokeAuthorizerRequest.authorizerId(), AUTHORIZERID_BINDING);
            protocolMarshaller.marshall(testInvokeAuthorizerRequest.headers(), HEADERS_BINDING);
            protocolMarshaller.marshall((Object)testInvokeAuthorizerRequest.pathWithQueryString(), PATHWITHQUERYSTRING_BINDING);
            protocolMarshaller.marshall((Object)testInvokeAuthorizerRequest.body(), BODY_BINDING);
            protocolMarshaller.marshall(testInvokeAuthorizerRequest.stageVariables(), STAGEVARIABLES_BINDING);
            protocolMarshaller.marshall(testInvokeAuthorizerRequest.additionalContext(), ADDITIONALCONTEXT_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

