/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.apigateway.model.SdkType;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SdkTypeMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("id").isBinary(false).build();
    private static final MarshallingInfo<String> FRIENDLYNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("friendlyName").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").isBinary(false).build();
    private static final MarshallingInfo<List> CONFIGURATIONPROPERTIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("configurationProperties").isBinary(false).build();
    private static final SdkTypeMarshaller INSTANCE = new SdkTypeMarshaller();

    private SdkTypeMarshaller() {
    }

    public static SdkTypeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SdkType sdkType, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)sdkType, (String)"sdkType");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)sdkType.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)sdkType.friendlyName(), FRIENDLYNAME_BINDING);
            protocolMarshaller.marshall((Object)sdkType.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(sdkType.configurationProperties(), CONFIGURATIONPROPERTIES_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

