/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.apigateway.model.MethodResponse;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class MethodResponseMarshaller {
    private static final MarshallingInfo<String> STATUSCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("statusCode").isBinary(false).build();
    private static final MarshallingInfo<Map> RESPONSEPARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("responseParameters").isBinary(false).build();
    private static final MarshallingInfo<Map> RESPONSEMODELS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("responseModels").isBinary(false).build();
    private static final MethodResponseMarshaller INSTANCE = new MethodResponseMarshaller();

    private MethodResponseMarshaller() {
    }

    public static MethodResponseMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(MethodResponse methodResponse, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)methodResponse, (String)"methodResponse");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)methodResponse.statusCode(), STATUSCODE_BINDING);
            protocolMarshaller.marshall(methodResponse.responseParameters(), RESPONSEPARAMETERS_BINDING);
            protocolMarshaller.marshall(methodResponse.responseModels(), RESPONSEMODELS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

