/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.apigateway.model.IntegrationResponse;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class IntegrationResponseMarshaller {
    private static final MarshallingInfo<String> STATUSCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("statusCode").isBinary(false).build();
    private static final MarshallingInfo<String> SELECTIONPATTERN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("selectionPattern").isBinary(false).build();
    private static final MarshallingInfo<Map> RESPONSEPARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("responseParameters").isBinary(false).build();
    private static final MarshallingInfo<Map> RESPONSETEMPLATES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("responseTemplates").isBinary(false).build();
    private static final MarshallingInfo<String> CONTENTHANDLING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("contentHandling").isBinary(false).build();
    private static final IntegrationResponseMarshaller INSTANCE = new IntegrationResponseMarshaller();

    private IntegrationResponseMarshaller() {
    }

    public static IntegrationResponseMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(IntegrationResponse integrationResponse, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)integrationResponse, (String)"integrationResponse");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)integrationResponse.statusCode(), STATUSCODE_BINDING);
            protocolMarshaller.marshall((Object)integrationResponse.selectionPattern(), SELECTIONPATTERN_BINDING);
            protocolMarshaller.marshall(integrationResponse.responseParameters(), RESPONSEPARAMETERS_BINDING);
            protocolMarshaller.marshall(integrationResponse.responseTemplates(), RESPONSETEMPLATES_BINDING);
            protocolMarshaller.marshall((Object)integrationResponse.contentHandlingAsString(), CONTENTHANDLING_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

