/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.apigateway.model.ImportRestApiRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ImportRestApiRequestModelMarshaller {
    private static final MarshallingInfo<Boolean> FAILONWARNINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("failonwarnings").isBinary(false).build();
    private static final MarshallingInfo<Map> PARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("parameters").isBinary(false).build();
    private static final MarshallingInfo<SdkBytes> BODY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.SDK_BYTES).marshallLocation(MarshallLocation.PAYLOAD).isExplicitPayloadMember(true).isBinary(true).build();
    private static final ImportRestApiRequestModelMarshaller INSTANCE = new ImportRestApiRequestModelMarshaller();

    private ImportRestApiRequestModelMarshaller() {
    }

    public static ImportRestApiRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ImportRestApiRequest importRestApiRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)importRestApiRequest), (String)"importRestApiRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)importRestApiRequest.failOnWarnings(), FAILONWARNINGS_BINDING);
            protocolMarshaller.marshall(importRestApiRequest.parameters(), PARAMETERS_BINDING);
            protocolMarshaller.marshall((Object)importRestApiRequest.body(), BODY_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

