/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.apigateway.model.DomainName;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DomainNameMarshaller {
    private static final MarshallingInfo<String> DOMAINNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("domainName").isBinary(false).build();
    private static final MarshallingInfo<String> CERTIFICATENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("certificateName").isBinary(false).build();
    private static final MarshallingInfo<String> CERTIFICATEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("certificateArn").isBinary(false).build();
    private static final MarshallingInfo<Instant> CERTIFICATEUPLOADDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("certificateUploadDate").isBinary(false).build();
    private static final MarshallingInfo<String> REGIONALDOMAINNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("regionalDomainName").isBinary(false).build();
    private static final MarshallingInfo<String> REGIONALHOSTEDZONEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("regionalHostedZoneId").isBinary(false).build();
    private static final MarshallingInfo<String> REGIONALCERTIFICATENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("regionalCertificateName").isBinary(false).build();
    private static final MarshallingInfo<String> REGIONALCERTIFICATEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("regionalCertificateArn").isBinary(false).build();
    private static final MarshallingInfo<String> DISTRIBUTIONDOMAINNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("distributionDomainName").isBinary(false).build();
    private static final MarshallingInfo<String> DISTRIBUTIONHOSTEDZONEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("distributionHostedZoneId").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ENDPOINTCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("endpointConfiguration").isBinary(false).build();
    private static final DomainNameMarshaller INSTANCE = new DomainNameMarshaller();

    private DomainNameMarshaller() {
    }

    public static DomainNameMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DomainName domainName, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)domainName, (String)"domainName");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)domainName.domainName(), DOMAINNAME_BINDING);
            protocolMarshaller.marshall((Object)domainName.certificateName(), CERTIFICATENAME_BINDING);
            protocolMarshaller.marshall((Object)domainName.certificateArn(), CERTIFICATEARN_BINDING);
            protocolMarshaller.marshall((Object)domainName.certificateUploadDate(), CERTIFICATEUPLOADDATE_BINDING);
            protocolMarshaller.marshall((Object)domainName.regionalDomainName(), REGIONALDOMAINNAME_BINDING);
            protocolMarshaller.marshall((Object)domainName.regionalHostedZoneId(), REGIONALHOSTEDZONEID_BINDING);
            protocolMarshaller.marshall((Object)domainName.regionalCertificateName(), REGIONALCERTIFICATENAME_BINDING);
            protocolMarshaller.marshall((Object)domainName.regionalCertificateArn(), REGIONALCERTIFICATEARN_BINDING);
            protocolMarshaller.marshall((Object)domainName.distributionDomainName(), DISTRIBUTIONDOMAINNAME_BINDING);
            protocolMarshaller.marshall((Object)domainName.distributionHostedZoneId(), DISTRIBUTIONHOSTEDZONEID_BINDING);
            protocolMarshaller.marshall((Object)domainName.endpointConfiguration(), ENDPOINTCONFIGURATION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

