/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.apigateway.model.DocumentationPart;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DocumentationPartMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("id").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> LOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("location").isBinary(false).build();
    private static final MarshallingInfo<String> PROPERTIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("properties").isBinary(false).build();
    private static final DocumentationPartMarshaller INSTANCE = new DocumentationPartMarshaller();

    private DocumentationPartMarshaller() {
    }

    public static DocumentationPartMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DocumentationPart documentationPart, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)documentationPart, (String)"documentationPart");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)documentationPart.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)documentationPart.location(), LOCATION_BINDING);
            protocolMarshaller.marshall((Object)documentationPart.properties(), PROPERTIES_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

