/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.apigateway.model.DocumentationPartLocation;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DocumentationPartLocationMarshaller {
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("type").isBinary(false).build();
    private static final MarshallingInfo<String> PATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("path").isBinary(false).build();
    private static final MarshallingInfo<String> METHOD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("method").isBinary(false).build();
    private static final MarshallingInfo<String> STATUSCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("statusCode").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();
    private static final DocumentationPartLocationMarshaller INSTANCE = new DocumentationPartLocationMarshaller();

    private DocumentationPartLocationMarshaller() {
    }

    public static DocumentationPartLocationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DocumentationPartLocation documentationPartLocation, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)documentationPartLocation, (String)"documentationPartLocation");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)documentationPartLocation.typeAsString(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)documentationPartLocation.path(), PATH_BINDING);
            protocolMarshaller.marshall((Object)documentationPartLocation.method(), METHOD_BINDING);
            protocolMarshaller.marshall((Object)documentationPartLocation.statusCode(), STATUSCODE_BINDING);
            protocolMarshaller.marshall((Object)documentationPartLocation.name(), NAME_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

