/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.transform;

import java.time.Instant;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.apigateway.model.Deployment;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DeploymentMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("id").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATEDDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createdDate").isBinary(false).build();
    private static final MarshallingInfo<Map> APISUMMARY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("apiSummary").isBinary(false).build();
    private static final DeploymentMarshaller INSTANCE = new DeploymentMarshaller();

    private DeploymentMarshaller() {
    }

    public static DeploymentMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Deployment deployment, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)deployment, (String)"deployment");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)deployment.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)deployment.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)deployment.createdDate(), CREATEDDATE_BINDING);
            protocolMarshaller.marshall(deployment.apiSummary(), APISUMMARY_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

