/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.apigateway.model.CreateRestApiRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateRestApiRequestModelMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").isBinary(false).build();
    private static final MarshallingInfo<String> VERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("version").isBinary(false).build();
    private static final MarshallingInfo<String> CLONEFROM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("cloneFrom").isBinary(false).build();
    private static final MarshallingInfo<List> BINARYMEDIATYPES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("binaryMediaTypes").isBinary(false).build();
    private static final MarshallingInfo<Integer> MINIMUMCOMPRESSIONSIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("minimumCompressionSize").isBinary(false).build();
    private static final MarshallingInfo<String> APIKEYSOURCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("apiKeySource").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ENDPOINTCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("endpointConfiguration").isBinary(false).build();
    private static final MarshallingInfo<String> POLICY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("policy").isBinary(false).build();
    private static final CreateRestApiRequestModelMarshaller INSTANCE = new CreateRestApiRequestModelMarshaller();

    private CreateRestApiRequestModelMarshaller() {
    }

    public static CreateRestApiRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateRestApiRequest createRestApiRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createRestApiRequest), (String)"createRestApiRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createRestApiRequest.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)createRestApiRequest.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)createRestApiRequest.version(), VERSION_BINDING);
            protocolMarshaller.marshall((Object)createRestApiRequest.cloneFrom(), CLONEFROM_BINDING);
            protocolMarshaller.marshall(createRestApiRequest.binaryMediaTypes(), BINARYMEDIATYPES_BINDING);
            protocolMarshaller.marshall((Object)createRestApiRequest.minimumCompressionSize(), MINIMUMCOMPRESSIONSIZE_BINDING);
            protocolMarshaller.marshall((Object)createRestApiRequest.apiKeySourceAsString(), APIKEYSOURCE_BINDING);
            protocolMarshaller.marshall((Object)createRestApiRequest.endpointConfiguration(), ENDPOINTCONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)createRestApiRequest.policy(), POLICY_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

