/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.apigateway.model.CreateModelRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateModelRequestModelMarshaller {
    private static final MarshallingInfo<String> RESTAPIID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("restapi_id").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").isBinary(false).build();
    private static final MarshallingInfo<String> SCHEMA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("schema").isBinary(false).build();
    private static final MarshallingInfo<String> CONTENTTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("contentType").isBinary(false).build();
    private static final CreateModelRequestModelMarshaller INSTANCE = new CreateModelRequestModelMarshaller();

    private CreateModelRequestModelMarshaller() {
    }

    public static CreateModelRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateModelRequest createModelRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createModelRequest), (String)"createModelRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createModelRequest.restApiId(), RESTAPIID_BINDING);
            protocolMarshaller.marshall((Object)createModelRequest.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)createModelRequest.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)createModelRequest.schema(), SCHEMA_BINDING);
            protocolMarshaller.marshall((Object)createModelRequest.contentType(), CONTENTTYPE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

