/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.apigateway.model.ClientCertificate;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ClientCertificateMarshaller {
    private static final MarshallingInfo<String> CLIENTCERTIFICATEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("clientCertificateId").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").isBinary(false).build();
    private static final MarshallingInfo<String> PEMENCODEDCERTIFICATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("pemEncodedCertificate").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATEDDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createdDate").isBinary(false).build();
    private static final MarshallingInfo<Instant> EXPIRATIONDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("expirationDate").isBinary(false).build();
    private static final ClientCertificateMarshaller INSTANCE = new ClientCertificateMarshaller();

    private ClientCertificateMarshaller() {
    }

    public static ClientCertificateMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ClientCertificate clientCertificate, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)clientCertificate, (String)"clientCertificate");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)clientCertificate.clientCertificateId(), CLIENTCERTIFICATEID_BINDING);
            protocolMarshaller.marshall((Object)clientCertificate.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)clientCertificate.pemEncodedCertificate(), PEMENCODEDCERTIFICATE_BINDING);
            protocolMarshaller.marshall((Object)clientCertificate.createdDate(), CREATEDDATE_BINDING);
            protocolMarshaller.marshall((Object)clientCertificate.expirationDate(), EXPIRATIONDATE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

