/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.apigateway.model.CanarySettings;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CanarySettingsMarshaller {
    private static final MarshallingInfo<Double> PERCENTTRAFFIC_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("percentTraffic").isBinary(false).build();
    private static final MarshallingInfo<String> DEPLOYMENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("deploymentId").isBinary(false).build();
    private static final MarshallingInfo<Map> STAGEVARIABLEOVERRIDES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stageVariableOverrides").isBinary(false).build();
    private static final MarshallingInfo<Boolean> USESTAGECACHE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("useStageCache").isBinary(false).build();
    private static final CanarySettingsMarshaller INSTANCE = new CanarySettingsMarshaller();

    private CanarySettingsMarshaller() {
    }

    public static CanarySettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CanarySettings canarySettings, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)canarySettings, (String)"canarySettings");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)canarySettings.percentTraffic(), PERCENTTRAFFIC_BINDING);
            protocolMarshaller.marshall((Object)canarySettings.deploymentId(), DEPLOYMENTID_BINDING);
            protocolMarshaller.marshall(canarySettings.stageVariableOverrides(), STAGEVARIABLEOVERRIDES_BINDING);
            protocolMarshaller.marshall((Object)canarySettings.useStageCache(), USESTAGECACHE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

