/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.apigateway.model.BasePathMapping;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class BasePathMappingMarshaller {
    private static final MarshallingInfo<String> BASEPATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("basePath").isBinary(false).build();
    private static final MarshallingInfo<String> RESTAPIID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("restApiId").isBinary(false).build();
    private static final MarshallingInfo<String> STAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stage").isBinary(false).build();
    private static final BasePathMappingMarshaller INSTANCE = new BasePathMappingMarshaller();

    private BasePathMappingMarshaller() {
    }

    public static BasePathMappingMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(BasePathMapping basePathMapping, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)basePathMapping, (String)"basePathMapping");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)basePathMapping.basePath(), BASEPATH_BINDING);
            protocolMarshaller.marshall((Object)basePathMapping.restApiId(), RESTAPIID_BINDING);
            protocolMarshaller.marshall((Object)basePathMapping.stage(), STAGE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

