/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.apigateway.transform.SdkConfigurationPropertyMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SdkConfigurationProperty
implements StructuredPojo,
ToCopyableBuilder<Builder, SdkConfigurationProperty> {
    private final String name;
    private final String friendlyName;
    private final String description;
    private final Boolean required;
    private final String defaultValue;

    private SdkConfigurationProperty(BuilderImpl builder) {
        this.name = builder.name;
        this.friendlyName = builder.friendlyName;
        this.description = builder.description;
        this.required = builder.required;
        this.defaultValue = builder.defaultValue;
    }

    public String name() {
        return this.name;
    }

    public String friendlyName() {
        return this.friendlyName;
    }

    public String description() {
        return this.description;
    }

    public Boolean required() {
        return this.required;
    }

    public String defaultValue() {
        return this.defaultValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.friendlyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.required());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultValue());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SdkConfigurationProperty)) {
            return false;
        }
        SdkConfigurationProperty other = (SdkConfigurationProperty)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.friendlyName(), other.friendlyName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.required(), other.required()) && Objects.equals(this.defaultValue(), other.defaultValue());
    }

    public String toString() {
        return ToString.builder((String)"SdkConfigurationProperty").add("Name", (Object)this.name()).add("FriendlyName", (Object)this.friendlyName()).add("Description", (Object)this.description()).add("Required", (Object)this.required()).add("DefaultValue", (Object)this.defaultValue()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "friendlyName": {
                return Optional.ofNullable(clazz.cast(this.friendlyName()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "required": {
                return Optional.ofNullable(clazz.cast(this.required()));
            }
            case "defaultValue": {
                return Optional.ofNullable(clazz.cast(this.defaultValue()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SdkConfigurationPropertyMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String friendlyName;
        private String description;
        private Boolean required;
        private String defaultValue;

        private BuilderImpl() {
        }

        private BuilderImpl(SdkConfigurationProperty model) {
            this.name(model.name);
            this.friendlyName(model.friendlyName);
            this.description(model.description);
            this.required(model.required);
            this.defaultValue(model.defaultValue);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getFriendlyName() {
            return this.friendlyName;
        }

        @Override
        public final Builder friendlyName(String friendlyName) {
            this.friendlyName = friendlyName;
            return this;
        }

        public final void setFriendlyName(String friendlyName) {
            this.friendlyName = friendlyName;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Boolean getRequired() {
            return this.required;
        }

        @Override
        public final Builder required(Boolean required) {
            this.required = required;
            return this;
        }

        public final void setRequired(Boolean required) {
            this.required = required;
        }

        public final String getDefaultValue() {
            return this.defaultValue;
        }

        @Override
        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public SdkConfigurationProperty build() {
            return new SdkConfigurationProperty(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SdkConfigurationProperty> {
        public Builder name(String var1);

        public Builder friendlyName(String var1);

        public Builder description(String var1);

        public Builder required(Boolean var1);

        public Builder defaultValue(String var1);
    }
}

