/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayRequest;
import software.amazon.awssdk.services.apigateway.model.ConnectionType;
import software.amazon.awssdk.services.apigateway.model.ContentHandlingStrategy;
import software.amazon.awssdk.services.apigateway.model.IntegrationType;
import software.amazon.awssdk.services.apigateway.model.ListOfStringCopier;
import software.amazon.awssdk.services.apigateway.model.MapOfStringToStringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutIntegrationRequest
extends ApiGatewayRequest
implements ToCopyableBuilder<Builder, PutIntegrationRequest> {
    private final String restApiId;
    private final String resourceId;
    private final String httpMethod;
    private final String type;
    private final String integrationHttpMethod;
    private final String uri;
    private final String connectionType;
    private final String connectionId;
    private final String credentials;
    private final Map<String, String> requestParameters;
    private final Map<String, String> requestTemplates;
    private final String passthroughBehavior;
    private final String cacheNamespace;
    private final List<String> cacheKeyParameters;
    private final String contentHandling;
    private final Integer timeoutInMillis;

    private PutIntegrationRequest(BuilderImpl builder) {
        super(builder);
        this.restApiId = builder.restApiId;
        this.resourceId = builder.resourceId;
        this.httpMethod = builder.httpMethod;
        this.type = builder.type;
        this.integrationHttpMethod = builder.integrationHttpMethod;
        this.uri = builder.uri;
        this.connectionType = builder.connectionType;
        this.connectionId = builder.connectionId;
        this.credentials = builder.credentials;
        this.requestParameters = builder.requestParameters;
        this.requestTemplates = builder.requestTemplates;
        this.passthroughBehavior = builder.passthroughBehavior;
        this.cacheNamespace = builder.cacheNamespace;
        this.cacheKeyParameters = builder.cacheKeyParameters;
        this.contentHandling = builder.contentHandling;
        this.timeoutInMillis = builder.timeoutInMillis;
    }

    public String restApiId() {
        return this.restApiId;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public String httpMethod() {
        return this.httpMethod;
    }

    public IntegrationType type() {
        return IntegrationType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public String integrationHttpMethod() {
        return this.integrationHttpMethod;
    }

    public String uri() {
        return this.uri;
    }

    public ConnectionType connectionType() {
        return ConnectionType.fromValue(this.connectionType);
    }

    public String connectionTypeAsString() {
        return this.connectionType;
    }

    public String connectionId() {
        return this.connectionId;
    }

    public String credentials() {
        return this.credentials;
    }

    public Map<String, String> requestParameters() {
        return this.requestParameters;
    }

    public Map<String, String> requestTemplates() {
        return this.requestTemplates;
    }

    public String passthroughBehavior() {
        return this.passthroughBehavior;
    }

    public String cacheNamespace() {
        return this.cacheNamespace;
    }

    public List<String> cacheKeyParameters() {
        return this.cacheKeyParameters;
    }

    public ContentHandlingStrategy contentHandling() {
        return ContentHandlingStrategy.fromValue(this.contentHandling);
    }

    public String contentHandlingAsString() {
        return this.contentHandling;
    }

    public Integer timeoutInMillis() {
        return this.timeoutInMillis;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.restApiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpMethod());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.integrationHttpMethod());
        hashCode = 31 * hashCode + Objects.hashCode(this.uri());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.credentials());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestTemplates());
        hashCode = 31 * hashCode + Objects.hashCode(this.passthroughBehavior());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheNamespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheKeyParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentHandlingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeoutInMillis());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutIntegrationRequest)) {
            return false;
        }
        PutIntegrationRequest other = (PutIntegrationRequest)((Object)obj);
        return Objects.equals(this.restApiId(), other.restApiId()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.httpMethod(), other.httpMethod()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.integrationHttpMethod(), other.integrationHttpMethod()) && Objects.equals(this.uri(), other.uri()) && Objects.equals(this.connectionTypeAsString(), other.connectionTypeAsString()) && Objects.equals(this.connectionId(), other.connectionId()) && Objects.equals(this.credentials(), other.credentials()) && Objects.equals(this.requestParameters(), other.requestParameters()) && Objects.equals(this.requestTemplates(), other.requestTemplates()) && Objects.equals(this.passthroughBehavior(), other.passthroughBehavior()) && Objects.equals(this.cacheNamespace(), other.cacheNamespace()) && Objects.equals(this.cacheKeyParameters(), other.cacheKeyParameters()) && Objects.equals(this.contentHandlingAsString(), other.contentHandlingAsString()) && Objects.equals(this.timeoutInMillis(), other.timeoutInMillis());
    }

    public String toString() {
        return ToString.builder((String)"PutIntegrationRequest").add("RestApiId", (Object)this.restApiId()).add("ResourceId", (Object)this.resourceId()).add("HttpMethod", (Object)this.httpMethod()).add("Type", (Object)this.typeAsString()).add("IntegrationHttpMethod", (Object)this.integrationHttpMethod()).add("Uri", (Object)this.uri()).add("ConnectionType", (Object)this.connectionTypeAsString()).add("ConnectionId", (Object)this.connectionId()).add("Credentials", (Object)this.credentials()).add("RequestParameters", this.requestParameters()).add("RequestTemplates", this.requestTemplates()).add("PassthroughBehavior", (Object)this.passthroughBehavior()).add("CacheNamespace", (Object)this.cacheNamespace()).add("CacheKeyParameters", this.cacheKeyParameters()).add("ContentHandling", (Object)this.contentHandlingAsString()).add("TimeoutInMillis", (Object)this.timeoutInMillis()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "restApiId": {
                return Optional.ofNullable(clazz.cast(this.restApiId()));
            }
            case "resourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "httpMethod": {
                return Optional.ofNullable(clazz.cast(this.httpMethod()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "integrationHttpMethod": {
                return Optional.ofNullable(clazz.cast(this.integrationHttpMethod()));
            }
            case "uri": {
                return Optional.ofNullable(clazz.cast(this.uri()));
            }
            case "connectionType": {
                return Optional.ofNullable(clazz.cast(this.connectionTypeAsString()));
            }
            case "connectionId": {
                return Optional.ofNullable(clazz.cast(this.connectionId()));
            }
            case "credentials": {
                return Optional.ofNullable(clazz.cast(this.credentials()));
            }
            case "requestParameters": {
                return Optional.ofNullable(clazz.cast(this.requestParameters()));
            }
            case "requestTemplates": {
                return Optional.ofNullable(clazz.cast(this.requestTemplates()));
            }
            case "passthroughBehavior": {
                return Optional.ofNullable(clazz.cast(this.passthroughBehavior()));
            }
            case "cacheNamespace": {
                return Optional.ofNullable(clazz.cast(this.cacheNamespace()));
            }
            case "cacheKeyParameters": {
                return Optional.ofNullable(clazz.cast(this.cacheKeyParameters()));
            }
            case "contentHandling": {
                return Optional.ofNullable(clazz.cast(this.contentHandlingAsString()));
            }
            case "timeoutInMillis": {
                return Optional.ofNullable(clazz.cast(this.timeoutInMillis()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ApiGatewayRequest.BuilderImpl
    implements Builder {
        private String restApiId;
        private String resourceId;
        private String httpMethod;
        private String type;
        private String integrationHttpMethod;
        private String uri;
        private String connectionType;
        private String connectionId;
        private String credentials;
        private Map<String, String> requestParameters = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> requestTemplates = DefaultSdkAutoConstructMap.getInstance();
        private String passthroughBehavior;
        private String cacheNamespace;
        private List<String> cacheKeyParameters = DefaultSdkAutoConstructList.getInstance();
        private String contentHandling;
        private Integer timeoutInMillis;

        private BuilderImpl() {
        }

        private BuilderImpl(PutIntegrationRequest model) {
            super(model);
            this.restApiId(model.restApiId);
            this.resourceId(model.resourceId);
            this.httpMethod(model.httpMethod);
            this.type(model.type);
            this.integrationHttpMethod(model.integrationHttpMethod);
            this.uri(model.uri);
            this.connectionType(model.connectionType);
            this.connectionId(model.connectionId);
            this.credentials(model.credentials);
            this.requestParameters(model.requestParameters);
            this.requestTemplates(model.requestTemplates);
            this.passthroughBehavior(model.passthroughBehavior);
            this.cacheNamespace(model.cacheNamespace);
            this.cacheKeyParameters(model.cacheKeyParameters);
            this.contentHandling(model.contentHandling);
            this.timeoutInMillis(model.timeoutInMillis);
        }

        public final String getRestApiId() {
            return this.restApiId;
        }

        @Override
        public final Builder restApiId(String restApiId) {
            this.restApiId = restApiId;
            return this;
        }

        public final void setRestApiId(String restApiId) {
            this.restApiId = restApiId;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getHttpMethod() {
            return this.httpMethod;
        }

        @Override
        public final Builder httpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        public final void setHttpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(IntegrationType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getIntegrationHttpMethod() {
            return this.integrationHttpMethod;
        }

        @Override
        public final Builder integrationHttpMethod(String integrationHttpMethod) {
            this.integrationHttpMethod = integrationHttpMethod;
            return this;
        }

        public final void setIntegrationHttpMethod(String integrationHttpMethod) {
            this.integrationHttpMethod = integrationHttpMethod;
        }

        public final String getUri() {
            return this.uri;
        }

        @Override
        public final Builder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public final void setUri(String uri) {
            this.uri = uri;
        }

        public final String getConnectionType() {
            return this.connectionType;
        }

        @Override
        public final Builder connectionType(String connectionType) {
            this.connectionType = connectionType;
            return this;
        }

        @Override
        public final Builder connectionType(ConnectionType connectionType) {
            this.connectionType(connectionType.toString());
            return this;
        }

        public final void setConnectionType(String connectionType) {
            this.connectionType = connectionType;
        }

        public final String getConnectionId() {
            return this.connectionId;
        }

        @Override
        public final Builder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public final void setConnectionId(String connectionId) {
            this.connectionId = connectionId;
        }

        public final String getCredentials() {
            return this.credentials;
        }

        @Override
        public final Builder credentials(String credentials) {
            this.credentials = credentials;
            return this;
        }

        public final void setCredentials(String credentials) {
            this.credentials = credentials;
        }

        public final Map<String, String> getRequestParameters() {
            return this.requestParameters;
        }

        @Override
        public final Builder requestParameters(Map<String, String> requestParameters) {
            this.requestParameters = MapOfStringToStringCopier.copy(requestParameters);
            return this;
        }

        public final void setRequestParameters(Map<String, String> requestParameters) {
            this.requestParameters = MapOfStringToStringCopier.copy(requestParameters);
        }

        public final Map<String, String> getRequestTemplates() {
            return this.requestTemplates;
        }

        @Override
        public final Builder requestTemplates(Map<String, String> requestTemplates) {
            this.requestTemplates = MapOfStringToStringCopier.copy(requestTemplates);
            return this;
        }

        public final void setRequestTemplates(Map<String, String> requestTemplates) {
            this.requestTemplates = MapOfStringToStringCopier.copy(requestTemplates);
        }

        public final String getPassthroughBehavior() {
            return this.passthroughBehavior;
        }

        @Override
        public final Builder passthroughBehavior(String passthroughBehavior) {
            this.passthroughBehavior = passthroughBehavior;
            return this;
        }

        public final void setPassthroughBehavior(String passthroughBehavior) {
            this.passthroughBehavior = passthroughBehavior;
        }

        public final String getCacheNamespace() {
            return this.cacheNamespace;
        }

        @Override
        public final Builder cacheNamespace(String cacheNamespace) {
            this.cacheNamespace = cacheNamespace;
            return this;
        }

        public final void setCacheNamespace(String cacheNamespace) {
            this.cacheNamespace = cacheNamespace;
        }

        public final Collection<String> getCacheKeyParameters() {
            return this.cacheKeyParameters;
        }

        @Override
        public final Builder cacheKeyParameters(Collection<String> cacheKeyParameters) {
            this.cacheKeyParameters = ListOfStringCopier.copy(cacheKeyParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheKeyParameters(String ... cacheKeyParameters) {
            this.cacheKeyParameters(Arrays.asList(cacheKeyParameters));
            return this;
        }

        public final void setCacheKeyParameters(Collection<String> cacheKeyParameters) {
            this.cacheKeyParameters = ListOfStringCopier.copy(cacheKeyParameters);
        }

        public final String getContentHandling() {
            return this.contentHandling;
        }

        @Override
        public final Builder contentHandling(String contentHandling) {
            this.contentHandling = contentHandling;
            return this;
        }

        @Override
        public final Builder contentHandling(ContentHandlingStrategy contentHandling) {
            this.contentHandling(contentHandling.toString());
            return this;
        }

        public final void setContentHandling(String contentHandling) {
            this.contentHandling = contentHandling;
        }

        public final Integer getTimeoutInMillis() {
            return this.timeoutInMillis;
        }

        @Override
        public final Builder timeoutInMillis(Integer timeoutInMillis) {
            this.timeoutInMillis = timeoutInMillis;
            return this;
        }

        public final void setTimeoutInMillis(Integer timeoutInMillis) {
            this.timeoutInMillis = timeoutInMillis;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutIntegrationRequest build() {
            return new PutIntegrationRequest(this);
        }
    }

    public static interface Builder
    extends ApiGatewayRequest.Builder,
    CopyableBuilder<Builder, PutIntegrationRequest> {
        public Builder restApiId(String var1);

        public Builder resourceId(String var1);

        public Builder httpMethod(String var1);

        public Builder type(String var1);

        public Builder type(IntegrationType var1);

        public Builder integrationHttpMethod(String var1);

        public Builder uri(String var1);

        public Builder connectionType(String var1);

        public Builder connectionType(ConnectionType var1);

        public Builder connectionId(String var1);

        public Builder credentials(String var1);

        public Builder requestParameters(Map<String, String> var1);

        public Builder requestTemplates(Map<String, String> var1);

        public Builder passthroughBehavior(String var1);

        public Builder cacheNamespace(String var1);

        public Builder cacheKeyParameters(Collection<String> var1);

        public Builder cacheKeyParameters(String ... var1);

        public Builder contentHandling(String var1);

        public Builder contentHandling(ContentHandlingStrategy var1);

        public Builder timeoutInMillis(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

