/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.apigateway.transform.MethodSnapshotMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MethodSnapshot
implements StructuredPojo,
ToCopyableBuilder<Builder, MethodSnapshot> {
    private final String authorizationType;
    private final Boolean apiKeyRequired;

    private MethodSnapshot(BuilderImpl builder) {
        this.authorizationType = builder.authorizationType;
        this.apiKeyRequired = builder.apiKeyRequired;
    }

    public String authorizationType() {
        return this.authorizationType;
    }

    public Boolean apiKeyRequired() {
        return this.apiKeyRequired;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizationType());
        hashCode = 31 * hashCode + Objects.hashCode(this.apiKeyRequired());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MethodSnapshot)) {
            return false;
        }
        MethodSnapshot other = (MethodSnapshot)obj;
        return Objects.equals(this.authorizationType(), other.authorizationType()) && Objects.equals(this.apiKeyRequired(), other.apiKeyRequired());
    }

    public String toString() {
        return ToString.builder((String)"MethodSnapshot").add("AuthorizationType", (Object)this.authorizationType()).add("ApiKeyRequired", (Object)this.apiKeyRequired()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "authorizationType": {
                return Optional.ofNullable(clazz.cast(this.authorizationType()));
            }
            case "apiKeyRequired": {
                return Optional.ofNullable(clazz.cast(this.apiKeyRequired()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MethodSnapshotMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String authorizationType;
        private Boolean apiKeyRequired;

        private BuilderImpl() {
        }

        private BuilderImpl(MethodSnapshot model) {
            this.authorizationType(model.authorizationType);
            this.apiKeyRequired(model.apiKeyRequired);
        }

        public final String getAuthorizationType() {
            return this.authorizationType;
        }

        @Override
        public final Builder authorizationType(String authorizationType) {
            this.authorizationType = authorizationType;
            return this;
        }

        public final void setAuthorizationType(String authorizationType) {
            this.authorizationType = authorizationType;
        }

        public final Boolean getApiKeyRequired() {
            return this.apiKeyRequired;
        }

        @Override
        public final Builder apiKeyRequired(Boolean apiKeyRequired) {
            this.apiKeyRequired = apiKeyRequired;
            return this;
        }

        public final void setApiKeyRequired(Boolean apiKeyRequired) {
            this.apiKeyRequired = apiKeyRequired;
        }

        public MethodSnapshot build() {
            return new MethodSnapshot(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, MethodSnapshot> {
        public Builder authorizationType(String var1);

        public Builder apiKeyRequired(Boolean var1);
    }
}

