/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayResponse;
import software.amazon.awssdk.services.apigateway.model.ListOfUsagePlanCopier;
import software.amazon.awssdk.services.apigateway.model.UsagePlan;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetUsagePlansResponse
extends ApiGatewayResponse
implements ToCopyableBuilder<Builder, GetUsagePlansResponse> {
    private final String position;
    private final List<UsagePlan> items;

    private GetUsagePlansResponse(BuilderImpl builder) {
        super(builder);
        this.position = builder.position;
        this.items = builder.items;
    }

    public String position() {
        return this.position;
    }

    public List<UsagePlan> items() {
        return this.items;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.position());
        hashCode = 31 * hashCode + Objects.hashCode(this.items());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUsagePlansResponse)) {
            return false;
        }
        GetUsagePlansResponse other = (GetUsagePlansResponse)((Object)obj);
        return Objects.equals(this.position(), other.position()) && Objects.equals(this.items(), other.items());
    }

    public String toString() {
        return ToString.builder((String)"GetUsagePlansResponse").add("Position", (Object)this.position()).add("Items", this.items()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "position": {
                return Optional.ofNullable(clazz.cast(this.position()));
            }
            case "items": {
                return Optional.ofNullable(clazz.cast(this.items()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ApiGatewayResponse.BuilderImpl
    implements Builder {
        private String position;
        private List<UsagePlan> items = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetUsagePlansResponse model) {
            super(model);
            this.position(model.position);
            this.items(model.items);
        }

        public final String getPosition() {
            return this.position;
        }

        @Override
        public final Builder position(String position) {
            this.position = position;
            return this;
        }

        public final void setPosition(String position) {
            this.position = position;
        }

        public final Collection<UsagePlan.Builder> getItems() {
            return this.items != null ? (Collection)this.items.stream().map(UsagePlan::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder items(Collection<UsagePlan> items) {
            this.items = ListOfUsagePlanCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(UsagePlan ... items) {
            this.items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<UsagePlan.Builder> ... items) {
            this.items(Stream.of(items).map(c -> (UsagePlan)((UsagePlan.Builder)UsagePlan.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setItems(Collection<UsagePlan.BuilderImpl> items) {
            this.items = ListOfUsagePlanCopier.copyFromBuilder(items);
        }

        @Override
        public GetUsagePlansResponse build() {
            return new GetUsagePlansResponse(this);
        }
    }

    public static interface Builder
    extends ApiGatewayResponse.Builder,
    CopyableBuilder<Builder, GetUsagePlansResponse> {
        public Builder position(String var1);

        public Builder items(Collection<UsagePlan> var1);

        public Builder items(UsagePlan ... var1);

        public Builder items(Consumer<UsagePlan.Builder> ... var1);
    }
}

