/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayResponse;
import software.amazon.awssdk.services.apigateway.model.ClientCertificate;
import software.amazon.awssdk.services.apigateway.model.ListOfClientCertificateCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetClientCertificatesResponse
extends ApiGatewayResponse
implements ToCopyableBuilder<Builder, GetClientCertificatesResponse> {
    private final String position;
    private final List<ClientCertificate> items;

    private GetClientCertificatesResponse(BuilderImpl builder) {
        super(builder);
        this.position = builder.position;
        this.items = builder.items;
    }

    public String position() {
        return this.position;
    }

    public List<ClientCertificate> items() {
        return this.items;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.position());
        hashCode = 31 * hashCode + Objects.hashCode(this.items());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetClientCertificatesResponse)) {
            return false;
        }
        GetClientCertificatesResponse other = (GetClientCertificatesResponse)((Object)obj);
        return Objects.equals(this.position(), other.position()) && Objects.equals(this.items(), other.items());
    }

    public String toString() {
        return ToString.builder((String)"GetClientCertificatesResponse").add("Position", (Object)this.position()).add("Items", this.items()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "position": {
                return Optional.ofNullable(clazz.cast(this.position()));
            }
            case "items": {
                return Optional.ofNullable(clazz.cast(this.items()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ApiGatewayResponse.BuilderImpl
    implements Builder {
        private String position;
        private List<ClientCertificate> items = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetClientCertificatesResponse model) {
            super(model);
            this.position(model.position);
            this.items(model.items);
        }

        public final String getPosition() {
            return this.position;
        }

        @Override
        public final Builder position(String position) {
            this.position = position;
            return this;
        }

        public final void setPosition(String position) {
            this.position = position;
        }

        public final Collection<ClientCertificate.Builder> getItems() {
            return this.items != null ? (Collection)this.items.stream().map(ClientCertificate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder items(Collection<ClientCertificate> items) {
            this.items = ListOfClientCertificateCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(ClientCertificate ... items) {
            this.items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<ClientCertificate.Builder> ... items) {
            this.items(Stream.of(items).map(c -> (ClientCertificate)((ClientCertificate.Builder)ClientCertificate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setItems(Collection<ClientCertificate.BuilderImpl> items) {
            this.items = ListOfClientCertificateCopier.copyFromBuilder(items);
        }

        @Override
        public GetClientCertificatesResponse build() {
            return new GetClientCertificatesResponse(this);
        }
    }

    public static interface Builder
    extends ApiGatewayResponse.Builder,
    CopyableBuilder<Builder, GetClientCertificatesResponse> {
        public Builder position(String var1);

        public Builder items(Collection<ClientCertificate> var1);

        public Builder items(ClientCertificate ... var1);

        public Builder items(Consumer<ClientCertificate.Builder> ... var1);
    }
}

