/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteAuthorizerRequest
extends ApiGatewayRequest
implements ToCopyableBuilder<Builder, DeleteAuthorizerRequest> {
    private final String restApiId;
    private final String authorizerId;

    private DeleteAuthorizerRequest(BuilderImpl builder) {
        super(builder);
        this.restApiId = builder.restApiId;
        this.authorizerId = builder.authorizerId;
    }

    public String restApiId() {
        return this.restApiId;
    }

    public String authorizerId() {
        return this.authorizerId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.restApiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizerId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteAuthorizerRequest)) {
            return false;
        }
        DeleteAuthorizerRequest other = (DeleteAuthorizerRequest)((Object)obj);
        return Objects.equals(this.restApiId(), other.restApiId()) && Objects.equals(this.authorizerId(), other.authorizerId());
    }

    public String toString() {
        return ToString.builder((String)"DeleteAuthorizerRequest").add("RestApiId", (Object)this.restApiId()).add("AuthorizerId", (Object)this.authorizerId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "restApiId": {
                return Optional.ofNullable(clazz.cast(this.restApiId()));
            }
            case "authorizerId": {
                return Optional.ofNullable(clazz.cast(this.authorizerId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ApiGatewayRequest.BuilderImpl
    implements Builder {
        private String restApiId;
        private String authorizerId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteAuthorizerRequest model) {
            super(model);
            this.restApiId(model.restApiId);
            this.authorizerId(model.authorizerId);
        }

        public final String getRestApiId() {
            return this.restApiId;
        }

        @Override
        public final Builder restApiId(String restApiId) {
            this.restApiId = restApiId;
            return this;
        }

        public final void setRestApiId(String restApiId) {
            this.restApiId = restApiId;
        }

        public final String getAuthorizerId() {
            return this.authorizerId;
        }

        @Override
        public final Builder authorizerId(String authorizerId) {
            this.authorizerId = authorizerId;
            return this;
        }

        public final void setAuthorizerId(String authorizerId) {
            this.authorizerId = authorizerId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteAuthorizerRequest build() {
            return new DeleteAuthorizerRequest(this);
        }
    }

    public static interface Builder
    extends ApiGatewayRequest.Builder,
    CopyableBuilder<Builder, DeleteAuthorizerRequest> {
        public Builder restApiId(String var1);

        public Builder authorizerId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

