/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateResourceRequest
extends ApiGatewayRequest
implements ToCopyableBuilder<Builder, CreateResourceRequest> {
    private final String restApiId;
    private final String parentId;
    private final String pathPart;

    private CreateResourceRequest(BuilderImpl builder) {
        super(builder);
        this.restApiId = builder.restApiId;
        this.parentId = builder.parentId;
        this.pathPart = builder.pathPart;
    }

    public String restApiId() {
        return this.restApiId;
    }

    public String parentId() {
        return this.parentId;
    }

    public String pathPart() {
        return this.pathPart;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.restApiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.pathPart());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateResourceRequest)) {
            return false;
        }
        CreateResourceRequest other = (CreateResourceRequest)((Object)obj);
        return Objects.equals(this.restApiId(), other.restApiId()) && Objects.equals(this.parentId(), other.parentId()) && Objects.equals(this.pathPart(), other.pathPart());
    }

    public String toString() {
        return ToString.builder((String)"CreateResourceRequest").add("RestApiId", (Object)this.restApiId()).add("ParentId", (Object)this.parentId()).add("PathPart", (Object)this.pathPart()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "restApiId": {
                return Optional.ofNullable(clazz.cast(this.restApiId()));
            }
            case "parentId": {
                return Optional.ofNullable(clazz.cast(this.parentId()));
            }
            case "pathPart": {
                return Optional.ofNullable(clazz.cast(this.pathPart()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ApiGatewayRequest.BuilderImpl
    implements Builder {
        private String restApiId;
        private String parentId;
        private String pathPart;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateResourceRequest model) {
            super(model);
            this.restApiId(model.restApiId);
            this.parentId(model.parentId);
            this.pathPart(model.pathPart);
        }

        public final String getRestApiId() {
            return this.restApiId;
        }

        @Override
        public final Builder restApiId(String restApiId) {
            this.restApiId = restApiId;
            return this;
        }

        public final void setRestApiId(String restApiId) {
            this.restApiId = restApiId;
        }

        public final String getParentId() {
            return this.parentId;
        }

        @Override
        public final Builder parentId(String parentId) {
            this.parentId = parentId;
            return this;
        }

        public final void setParentId(String parentId) {
            this.parentId = parentId;
        }

        public final String getPathPart() {
            return this.pathPart;
        }

        @Override
        public final Builder pathPart(String pathPart) {
            this.pathPart = pathPart;
            return this;
        }

        public final void setPathPart(String pathPart) {
            this.pathPart = pathPart;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateResourceRequest build() {
            return new CreateResourceRequest(this);
        }
    }

    public static interface Builder
    extends ApiGatewayRequest.Builder,
    CopyableBuilder<Builder, CreateResourceRequest> {
        public Builder restApiId(String var1);

        public Builder parentId(String var1);

        public Builder pathPart(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

