/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateBasePathMappingRequest
extends ApiGatewayRequest
implements ToCopyableBuilder<Builder, CreateBasePathMappingRequest> {
    private final String domainName;
    private final String basePath;
    private final String restApiId;
    private final String stage;

    private CreateBasePathMappingRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.basePath = builder.basePath;
        this.restApiId = builder.restApiId;
        this.stage = builder.stage;
    }

    public String domainName() {
        return this.domainName;
    }

    public String basePath() {
        return this.basePath;
    }

    public String restApiId() {
        return this.restApiId;
    }

    public String stage() {
        return this.stage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.basePath());
        hashCode = 31 * hashCode + Objects.hashCode(this.restApiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stage());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBasePathMappingRequest)) {
            return false;
        }
        CreateBasePathMappingRequest other = (CreateBasePathMappingRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.basePath(), other.basePath()) && Objects.equals(this.restApiId(), other.restApiId()) && Objects.equals(this.stage(), other.stage());
    }

    public String toString() {
        return ToString.builder((String)"CreateBasePathMappingRequest").add("DomainName", (Object)this.domainName()).add("BasePath", (Object)this.basePath()).add("RestApiId", (Object)this.restApiId()).add("Stage", (Object)this.stage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "basePath": {
                return Optional.ofNullable(clazz.cast(this.basePath()));
            }
            case "restApiId": {
                return Optional.ofNullable(clazz.cast(this.restApiId()));
            }
            case "stage": {
                return Optional.ofNullable(clazz.cast(this.stage()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ApiGatewayRequest.BuilderImpl
    implements Builder {
        private String domainName;
        private String basePath;
        private String restApiId;
        private String stage;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBasePathMappingRequest model) {
            super(model);
            this.domainName(model.domainName);
            this.basePath(model.basePath);
            this.restApiId(model.restApiId);
            this.stage(model.stage);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getBasePath() {
            return this.basePath;
        }

        @Override
        public final Builder basePath(String basePath) {
            this.basePath = basePath;
            return this;
        }

        public final void setBasePath(String basePath) {
            this.basePath = basePath;
        }

        public final String getRestApiId() {
            return this.restApiId;
        }

        @Override
        public final Builder restApiId(String restApiId) {
            this.restApiId = restApiId;
            return this;
        }

        public final void setRestApiId(String restApiId) {
            this.restApiId = restApiId;
        }

        public final String getStage() {
            return this.stage;
        }

        @Override
        public final Builder stage(String stage) {
            this.stage = stage;
            return this;
        }

        public final void setStage(String stage) {
            this.stage = stage;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateBasePathMappingRequest build() {
            return new CreateBasePathMappingRequest(this);
        }
    }

    public static interface Builder
    extends ApiGatewayRequest.Builder,
    CopyableBuilder<Builder, CreateBasePathMappingRequest> {
        public Builder domainName(String var1);

        public Builder basePath(String var1);

        public Builder restApiId(String var1);

        public Builder stage(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

