/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.apache5.internal.impl;

import java.io.IOException;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.protocol.HttpContext;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.http.apache5.internal.impl.ConnectionManagerAwareHttpClient;

@SdkInternalApi
public class Apache5SdkHttpClient
implements ConnectionManagerAwareHttpClient {
    private final HttpClient delegate;
    private final HttpClientConnectionManager cm;

    public Apache5SdkHttpClient(HttpClient delegate, HttpClientConnectionManager cm) {
        if (delegate == null) {
            throw new IllegalArgumentException("delegate cannot be null");
        }
        if (cm == null) {
            throw new IllegalArgumentException("connection manager cannot be null");
        }
        this.delegate = delegate;
        this.cm = cm;
    }

    public HttpResponse execute(ClassicHttpRequest request) throws IOException {
        return this.delegate.execute(request);
    }

    public HttpResponse execute(ClassicHttpRequest request, HttpContext context) throws IOException {
        return this.delegate.execute(request, context);
    }

    public ClassicHttpResponse execute(HttpHost target, ClassicHttpRequest request) throws IOException {
        return this.delegate.execute(target, request);
    }

    public HttpResponse execute(HttpHost target, ClassicHttpRequest request, HttpContext context) throws IOException {
        return this.delegate.execute(target, request, context);
    }

    public <T> T execute(ClassicHttpRequest request, HttpClientResponseHandler<? extends T> responseHandler) throws IOException {
        return (T)this.delegate.execute(request, responseHandler);
    }

    public <T> T execute(ClassicHttpRequest request, HttpContext context, HttpClientResponseHandler<? extends T> responseHandler) throws IOException {
        return (T)this.delegate.execute(request, context, responseHandler);
    }

    public <T> T execute(HttpHost target, ClassicHttpRequest request, HttpClientResponseHandler<? extends T> responseHandler) throws IOException {
        return (T)this.delegate.execute(target, request, responseHandler);
    }

    public <T> T execute(HttpHost target, ClassicHttpRequest request, HttpContext context, HttpClientResponseHandler<? extends T> responseHandler) throws IOException {
        return (T)this.delegate.execute(target, request, context, responseHandler);
    }

    @Override
    public HttpClientConnectionManager getHttpClientConnectionManager() {
        return this.cm;
    }
}

