/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.apache5.internal.conn;

import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.apache.hc.client5.http.io.ConnectionEndpoint;
import org.apache.hc.client5.http.io.LeaseRequest;
import org.apache.hc.core5.util.Timeout;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.http.HttpMetric;
import software.amazon.awssdk.metrics.MetricCollector;

@SdkInternalApi
public final class ClientConnectionRequestFactory {
    public static final ThreadLocal<MetricCollector> THREAD_LOCAL_REQUEST_METRIC_COLLECTOR = new ThreadLocal();

    private ClientConnectionRequestFactory() {
    }

    static LeaseRequest wrap(LeaseRequest orig) {
        if (orig instanceof DelegatingConnectionRequest) {
            throw new IllegalArgumentException();
        }
        return new InstrumentedConnectionRequest(orig);
    }

    private static class DelegatingConnectionRequest
    implements LeaseRequest {
        private final LeaseRequest delegate;

        private DelegatingConnectionRequest(LeaseRequest delegate) {
            this.delegate = delegate;
        }

        public boolean cancel() {
            return this.delegate.cancel();
        }

        public ConnectionEndpoint get(Timeout timeout) throws InterruptedException, ExecutionException, TimeoutException {
            return this.delegate.get(timeout);
        }
    }

    private static class InstrumentedConnectionRequest
    extends DelegatingConnectionRequest {
        private InstrumentedConnectionRequest(LeaseRequest delegate) {
            super(delegate);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ConnectionEndpoint get(Timeout timeout) throws InterruptedException, ExecutionException, TimeoutException {
            Instant startTime = Instant.now();
            try {
                ConnectionEndpoint connectionEndpoint = super.get(timeout);
                return connectionEndpoint;
            }
            finally {
                Duration elapsed = Duration.between(startTime, Instant.now());
                MetricCollector metricCollector = THREAD_LOCAL_REQUEST_METRIC_COLLECTOR.get();
                metricCollector.reportMetric(HttpMetric.CONCURRENCY_ACQUIRE_DURATION, (Object)elapsed);
            }
        }
    }
}

