/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.amplifyuibuilder.model.Predicate;
import software.amazon.awssdk.services.amplifyuibuilder.model.PredicateListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ComponentBindingPropertiesValueProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ComponentBindingPropertiesValueProperties> {
    private static final SdkField<String> MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("model").getter(ComponentBindingPropertiesValueProperties.getter(ComponentBindingPropertiesValueProperties::model)).setter(ComponentBindingPropertiesValueProperties.setter(Builder::model)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("model").build()}).build();
    private static final SdkField<String> FIELD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("field").getter(ComponentBindingPropertiesValueProperties.getter(ComponentBindingPropertiesValueProperties::field)).setter(ComponentBindingPropertiesValueProperties.setter(Builder::field)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("field").build()}).build();
    private static final SdkField<List<Predicate>> PREDICATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("predicates").getter(ComponentBindingPropertiesValueProperties.getter(ComponentBindingPropertiesValueProperties::predicates)).setter(ComponentBindingPropertiesValueProperties.setter(Builder::predicates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("predicates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Predicate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> USER_ATTRIBUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userAttribute").getter(ComponentBindingPropertiesValueProperties.getter(ComponentBindingPropertiesValueProperties::userAttribute)).setter(ComponentBindingPropertiesValueProperties.setter(Builder::userAttribute)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userAttribute").build()}).build();
    private static final SdkField<String> BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("bucket").getter(ComponentBindingPropertiesValueProperties.getter(ComponentBindingPropertiesValueProperties::bucket)).setter(ComponentBindingPropertiesValueProperties.setter(Builder::bucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucket").build()}).build();
    private static final SdkField<String> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("key").getter(ComponentBindingPropertiesValueProperties.getter(ComponentBindingPropertiesValueProperties::key)).setter(ComponentBindingPropertiesValueProperties.setter(Builder::key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("key").build()}).build();
    private static final SdkField<String> DEFAULT_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("defaultValue").getter(ComponentBindingPropertiesValueProperties.getter(ComponentBindingPropertiesValueProperties::defaultValue)).setter(ComponentBindingPropertiesValueProperties.setter(Builder::defaultValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultValue").build()}).build();
    private static final SdkField<String> SLOT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("slotName").getter(ComponentBindingPropertiesValueProperties.getter(ComponentBindingPropertiesValueProperties::slotName)).setter(ComponentBindingPropertiesValueProperties.setter(Builder::slotName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_FIELD, FIELD_FIELD, PREDICATES_FIELD, USER_ATTRIBUTE_FIELD, BUCKET_FIELD, KEY_FIELD, DEFAULT_VALUE_FIELD, SLOT_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ComponentBindingPropertiesValueProperties.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String model;
    private final String field;
    private final List<Predicate> predicates;
    private final String userAttribute;
    private final String bucket;
    private final String key;
    private final String defaultValue;
    private final String slotName;

    private ComponentBindingPropertiesValueProperties(BuilderImpl builder) {
        this.model = builder.model;
        this.field = builder.field;
        this.predicates = builder.predicates;
        this.userAttribute = builder.userAttribute;
        this.bucket = builder.bucket;
        this.key = builder.key;
        this.defaultValue = builder.defaultValue;
        this.slotName = builder.slotName;
    }

    public final String model() {
        return this.model;
    }

    public final String field() {
        return this.field;
    }

    public final boolean hasPredicates() {
        return this.predicates != null && !(this.predicates instanceof SdkAutoConstructList);
    }

    public final List<Predicate> predicates() {
        return this.predicates;
    }

    public final String userAttribute() {
        return this.userAttribute;
    }

    public final String bucket() {
        return this.bucket;
    }

    public final String key() {
        return this.key;
    }

    public final String defaultValue() {
        return this.defaultValue;
    }

    public final String slotName() {
        return this.slotName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.model());
        hashCode = 31 * hashCode + Objects.hashCode(this.field());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPredicates() ? this.predicates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.userAttribute());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.slotName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComponentBindingPropertiesValueProperties)) {
            return false;
        }
        ComponentBindingPropertiesValueProperties other = (ComponentBindingPropertiesValueProperties)obj;
        return Objects.equals(this.model(), other.model()) && Objects.equals(this.field(), other.field()) && this.hasPredicates() == other.hasPredicates() && Objects.equals(this.predicates(), other.predicates()) && Objects.equals(this.userAttribute(), other.userAttribute()) && Objects.equals(this.bucket(), other.bucket()) && Objects.equals(this.key(), other.key()) && Objects.equals(this.defaultValue(), other.defaultValue()) && Objects.equals(this.slotName(), other.slotName());
    }

    public final String toString() {
        return ToString.builder((String)"ComponentBindingPropertiesValueProperties").add("Model", (Object)this.model()).add("Field", (Object)this.field()).add("Predicates", this.hasPredicates() ? this.predicates() : null).add("UserAttribute", (Object)this.userAttribute()).add("Bucket", (Object)this.bucket()).add("Key", (Object)this.key()).add("DefaultValue", (Object)this.defaultValue()).add("SlotName", (Object)this.slotName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "model": {
                return Optional.ofNullable(clazz.cast(this.model()));
            }
            case "field": {
                return Optional.ofNullable(clazz.cast(this.field()));
            }
            case "predicates": {
                return Optional.ofNullable(clazz.cast(this.predicates()));
            }
            case "userAttribute": {
                return Optional.ofNullable(clazz.cast(this.userAttribute()));
            }
            case "bucket": {
                return Optional.ofNullable(clazz.cast(this.bucket()));
            }
            case "key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
            case "defaultValue": {
                return Optional.ofNullable(clazz.cast(this.defaultValue()));
            }
            case "slotName": {
                return Optional.ofNullable(clazz.cast(this.slotName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("model", MODEL_FIELD);
        map.put("field", FIELD_FIELD);
        map.put("predicates", PREDICATES_FIELD);
        map.put("userAttribute", USER_ATTRIBUTE_FIELD);
        map.put("bucket", BUCKET_FIELD);
        map.put("key", KEY_FIELD);
        map.put("defaultValue", DEFAULT_VALUE_FIELD);
        map.put("slotName", SLOT_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ComponentBindingPropertiesValueProperties, T> g) {
        return obj -> g.apply((ComponentBindingPropertiesValueProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String model;
        private String field;
        private List<Predicate> predicates = DefaultSdkAutoConstructList.getInstance();
        private String userAttribute;
        private String bucket;
        private String key;
        private String defaultValue;
        private String slotName;

        private BuilderImpl() {
        }

        private BuilderImpl(ComponentBindingPropertiesValueProperties model) {
            this.model(model.model);
            this.field(model.field);
            this.predicates(model.predicates);
            this.userAttribute(model.userAttribute);
            this.bucket(model.bucket);
            this.key(model.key);
            this.defaultValue(model.defaultValue);
            this.slotName(model.slotName);
        }

        public final String getModel() {
            return this.model;
        }

        public final void setModel(String model) {
            this.model = model;
        }

        @Override
        public final Builder model(String model) {
            this.model = model;
            return this;
        }

        public final String getField() {
            return this.field;
        }

        public final void setField(String field) {
            this.field = field;
        }

        @Override
        public final Builder field(String field) {
            this.field = field;
            return this;
        }

        public final List<Predicate.Builder> getPredicates() {
            List<Predicate.Builder> result = PredicateListCopier.copyToBuilder(this.predicates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPredicates(Collection<Predicate.BuilderImpl> predicates) {
            this.predicates = PredicateListCopier.copyFromBuilder(predicates);
        }

        @Override
        public final Builder predicates(Collection<Predicate> predicates) {
            this.predicates = PredicateListCopier.copy(predicates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder predicates(Predicate ... predicates) {
            this.predicates(Arrays.asList(predicates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder predicates(Consumer<Predicate.Builder> ... predicates) {
            this.predicates(Stream.of(predicates).map(c -> (Predicate)((Predicate.Builder)Predicate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getUserAttribute() {
            return this.userAttribute;
        }

        public final void setUserAttribute(String userAttribute) {
            this.userAttribute = userAttribute;
        }

        @Override
        public final Builder userAttribute(String userAttribute) {
            this.userAttribute = userAttribute;
            return this;
        }

        public final String getBucket() {
            return this.bucket;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final String getKey() {
            return this.key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final String getDefaultValue() {
            return this.defaultValue;
        }

        public final void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final String getSlotName() {
            return this.slotName;
        }

        public final void setSlotName(String slotName) {
            this.slotName = slotName;
        }

        @Override
        public final Builder slotName(String slotName) {
            this.slotName = slotName;
            return this;
        }

        public ComponentBindingPropertiesValueProperties build() {
            return new ComponentBindingPropertiesValueProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ComponentBindingPropertiesValueProperties> {
        public Builder model(String var1);

        public Builder field(String var1);

        public Builder predicates(Collection<Predicate> var1);

        public Builder predicates(Predicate ... var1);

        public Builder predicates(Consumer<Predicate.Builder> ... var1);

        public Builder userAttribute(String var1);

        public Builder bucket(String var1);

        public Builder key(String var1);

        public Builder defaultValue(String var1);

        public Builder slotName(String var1);
    }
}

