/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.amplifyuibuilder.model.IdentifierListCopier;
import software.amazon.awssdk.services.amplifyuibuilder.model.Predicate;
import software.amazon.awssdk.services.amplifyuibuilder.model.SortProperty;
import software.amazon.awssdk.services.amplifyuibuilder.model.SortPropertyListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ComponentDataConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ComponentDataConfiguration> {
    private static final SdkField<String> MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("model").getter(ComponentDataConfiguration.getter(ComponentDataConfiguration::model)).setter(ComponentDataConfiguration.setter(Builder::model)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("model").build()}).build();
    private static final SdkField<List<SortProperty>> SORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sort").getter(ComponentDataConfiguration.getter(ComponentDataConfiguration::sort)).setter(ComponentDataConfiguration.setter(Builder::sort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sort").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SortProperty::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Predicate> PREDICATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("predicate").getter(ComponentDataConfiguration.getter(ComponentDataConfiguration::predicate)).setter(ComponentDataConfiguration.setter(Builder::predicate)).constructor(Predicate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("predicate").build()}).build();
    private static final SdkField<List<String>> IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("identifiers").getter(ComponentDataConfiguration.getter(ComponentDataConfiguration::identifiers)).setter(ComponentDataConfiguration.setter(Builder::identifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_FIELD, SORT_FIELD, PREDICATE_FIELD, IDENTIFIERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ComponentDataConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String model;
    private final List<SortProperty> sort;
    private final Predicate predicate;
    private final List<String> identifiers;

    private ComponentDataConfiguration(BuilderImpl builder) {
        this.model = builder.model;
        this.sort = builder.sort;
        this.predicate = builder.predicate;
        this.identifiers = builder.identifiers;
    }

    public final String model() {
        return this.model;
    }

    public final boolean hasSort() {
        return this.sort != null && !(this.sort instanceof SdkAutoConstructList);
    }

    public final List<SortProperty> sort() {
        return this.sort;
    }

    public final Predicate predicate() {
        return this.predicate;
    }

    public final boolean hasIdentifiers() {
        return this.identifiers != null && !(this.identifiers instanceof SdkAutoConstructList);
    }

    public final List<String> identifiers() {
        return this.identifiers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.model());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSort() ? this.sort() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.predicate());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIdentifiers() ? this.identifiers() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComponentDataConfiguration)) {
            return false;
        }
        ComponentDataConfiguration other = (ComponentDataConfiguration)obj;
        return Objects.equals(this.model(), other.model()) && this.hasSort() == other.hasSort() && Objects.equals(this.sort(), other.sort()) && Objects.equals(this.predicate(), other.predicate()) && this.hasIdentifiers() == other.hasIdentifiers() && Objects.equals(this.identifiers(), other.identifiers());
    }

    public final String toString() {
        return ToString.builder((String)"ComponentDataConfiguration").add("Model", (Object)this.model()).add("Sort", this.hasSort() ? this.sort() : null).add("Predicate", (Object)this.predicate()).add("Identifiers", this.hasIdentifiers() ? this.identifiers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "model": {
                return Optional.ofNullable(clazz.cast(this.model()));
            }
            case "sort": {
                return Optional.ofNullable(clazz.cast(this.sort()));
            }
            case "predicate": {
                return Optional.ofNullable(clazz.cast(this.predicate()));
            }
            case "identifiers": {
                return Optional.ofNullable(clazz.cast(this.identifiers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("model", MODEL_FIELD);
        map.put("sort", SORT_FIELD);
        map.put("predicate", PREDICATE_FIELD);
        map.put("identifiers", IDENTIFIERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ComponentDataConfiguration, T> g) {
        return obj -> g.apply((ComponentDataConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String model;
        private List<SortProperty> sort = DefaultSdkAutoConstructList.getInstance();
        private Predicate predicate;
        private List<String> identifiers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ComponentDataConfiguration model) {
            this.model(model.model);
            this.sort(model.sort);
            this.predicate(model.predicate);
            this.identifiers(model.identifiers);
        }

        public final String getModel() {
            return this.model;
        }

        public final void setModel(String model) {
            this.model = model;
        }

        @Override
        public final Builder model(String model) {
            this.model = model;
            return this;
        }

        public final List<SortProperty.Builder> getSort() {
            List<SortProperty.Builder> result = SortPropertyListCopier.copyToBuilder(this.sort);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSort(Collection<SortProperty.BuilderImpl> sort) {
            this.sort = SortPropertyListCopier.copyFromBuilder(sort);
        }

        @Override
        public final Builder sort(Collection<SortProperty> sort) {
            this.sort = SortPropertyListCopier.copy(sort);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sort(SortProperty ... sort) {
            this.sort(Arrays.asList(sort));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sort(Consumer<SortProperty.Builder> ... sort) {
            this.sort(Stream.of(sort).map(c -> (SortProperty)((SortProperty.Builder)SortProperty.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Predicate.Builder getPredicate() {
            return this.predicate != null ? this.predicate.toBuilder() : null;
        }

        public final void setPredicate(Predicate.BuilderImpl predicate) {
            this.predicate = predicate != null ? predicate.build() : null;
        }

        @Override
        public final Builder predicate(Predicate predicate) {
            this.predicate = predicate;
            return this;
        }

        public final Collection<String> getIdentifiers() {
            if (this.identifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.identifiers;
        }

        public final void setIdentifiers(Collection<String> identifiers) {
            this.identifiers = IdentifierListCopier.copy(identifiers);
        }

        @Override
        public final Builder identifiers(Collection<String> identifiers) {
            this.identifiers = IdentifierListCopier.copy(identifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identifiers(String ... identifiers) {
            this.identifiers(Arrays.asList(identifiers));
            return this;
        }

        public ComponentDataConfiguration build() {
            return new ComponentDataConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ComponentDataConfiguration> {
        public Builder model(String var1);

        public Builder sort(Collection<SortProperty> var1);

        public Builder sort(SortProperty ... var1);

        public Builder sort(Consumer<SortProperty.Builder> ... var1);

        public Builder predicate(Predicate var1);

        default public Builder predicate(Consumer<Predicate.Builder> predicate) {
            return this.predicate((Predicate)((Predicate.Builder)Predicate.builder().applyMutation(predicate)).build());
        }

        public Builder identifiers(Collection<String> var1);

        public Builder identifiers(String ... var1);
    }
}

