/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.amplifyuibuilder.model.FormButton;
import software.amazon.awssdk.services.amplifyuibuilder.model.FormButtonsPosition;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FormCTA
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FormCTA> {
    private static final SdkField<FormButton> CANCEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("cancel").getter(FormCTA.getter(FormCTA::cancel)).setter(FormCTA.setter(Builder::cancel)).constructor(FormButton::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cancel").build()}).build();
    private static final SdkField<FormButton> CLEAR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("clear").getter(FormCTA.getter(FormCTA::clear)).setter(FormCTA.setter(Builder::clear)).constructor(FormButton::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clear").build()}).build();
    private static final SdkField<String> POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("position").getter(FormCTA.getter(FormCTA::positionAsString)).setter(FormCTA.setter(Builder::position)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("position").build()}).build();
    private static final SdkField<FormButton> SUBMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("submit").getter(FormCTA.getter(FormCTA::submit)).setter(FormCTA.setter(Builder::submit)).constructor(FormButton::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("submit").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CANCEL_FIELD, CLEAR_FIELD, POSITION_FIELD, SUBMIT_FIELD));
    private static final long serialVersionUID = 1L;
    private final FormButton cancel;
    private final FormButton clear;
    private final String position;
    private final FormButton submit;

    private FormCTA(BuilderImpl builder) {
        this.cancel = builder.cancel;
        this.clear = builder.clear;
        this.position = builder.position;
        this.submit = builder.submit;
    }

    public final FormButton cancel() {
        return this.cancel;
    }

    public final FormButton clear() {
        return this.clear;
    }

    public final FormButtonsPosition position() {
        return FormButtonsPosition.fromValue(this.position);
    }

    public final String positionAsString() {
        return this.position;
    }

    public final FormButton submit() {
        return this.submit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cancel());
        hashCode = 31 * hashCode + Objects.hashCode(this.clear());
        hashCode = 31 * hashCode + Objects.hashCode(this.positionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.submit());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FormCTA)) {
            return false;
        }
        FormCTA other = (FormCTA)obj;
        return Objects.equals(this.cancel(), other.cancel()) && Objects.equals(this.clear(), other.clear()) && Objects.equals(this.positionAsString(), other.positionAsString()) && Objects.equals(this.submit(), other.submit());
    }

    public final String toString() {
        return ToString.builder((String)"FormCTA").add("Cancel", (Object)this.cancel()).add("Clear", (Object)this.clear()).add("Position", (Object)this.positionAsString()).add("Submit", (Object)this.submit()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cancel": {
                return Optional.ofNullable(clazz.cast(this.cancel()));
            }
            case "clear": {
                return Optional.ofNullable(clazz.cast(this.clear()));
            }
            case "position": {
                return Optional.ofNullable(clazz.cast(this.positionAsString()));
            }
            case "submit": {
                return Optional.ofNullable(clazz.cast(this.submit()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FormCTA, T> g) {
        return obj -> g.apply((FormCTA)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private FormButton cancel;
        private FormButton clear;
        private String position;
        private FormButton submit;

        private BuilderImpl() {
        }

        private BuilderImpl(FormCTA model) {
            this.cancel(model.cancel);
            this.clear(model.clear);
            this.position(model.position);
            this.submit(model.submit);
        }

        public final FormButton.Builder getCancel() {
            return this.cancel != null ? this.cancel.toBuilder() : null;
        }

        public final void setCancel(FormButton.BuilderImpl cancel) {
            this.cancel = cancel != null ? cancel.build() : null;
        }

        @Override
        public final Builder cancel(FormButton cancel) {
            this.cancel = cancel;
            return this;
        }

        public final FormButton.Builder getClear() {
            return this.clear != null ? this.clear.toBuilder() : null;
        }

        public final void setClear(FormButton.BuilderImpl clear) {
            this.clear = clear != null ? clear.build() : null;
        }

        @Override
        public final Builder clear(FormButton clear) {
            this.clear = clear;
            return this;
        }

        public final String getPosition() {
            return this.position;
        }

        public final void setPosition(String position) {
            this.position = position;
        }

        @Override
        public final Builder position(String position) {
            this.position = position;
            return this;
        }

        @Override
        public final Builder position(FormButtonsPosition position) {
            this.position(position == null ? null : position.toString());
            return this;
        }

        public final FormButton.Builder getSubmit() {
            return this.submit != null ? this.submit.toBuilder() : null;
        }

        public final void setSubmit(FormButton.BuilderImpl submit) {
            this.submit = submit != null ? submit.build() : null;
        }

        @Override
        public final Builder submit(FormButton submit) {
            this.submit = submit;
            return this;
        }

        public FormCTA build() {
            return new FormCTA(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FormCTA> {
        public Builder cancel(FormButton var1);

        default public Builder cancel(Consumer<FormButton.Builder> cancel) {
            return this.cancel((FormButton)((FormButton.Builder)FormButton.builder().applyMutation(cancel)).build());
        }

        public Builder clear(FormButton var1);

        default public Builder clear(Consumer<FormButton.Builder> clear) {
            return this.clear((FormButton)((FormButton.Builder)FormButton.builder().applyMutation(clear)).build());
        }

        public Builder position(String var1);

        public Builder position(FormButtonsPosition var1);

        public Builder submit(FormButton var1);

        default public Builder submit(Consumer<FormButton.Builder> submit) {
            return this.submit((FormButton)((FormButton.Builder)FormButton.builder().applyMutation(submit)).build());
        }
    }
}

