/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.amplifyuibuilder.model.ComponentPropertiesCopier;
import software.amazon.awssdk.services.amplifyuibuilder.model.ComponentProperty;
import software.amazon.awssdk.services.amplifyuibuilder.model.MutationActionSetStateParameter;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ActionParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ActionParameters> {
    private static final SdkField<ComponentProperty> ANCHOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("anchor").getter(ActionParameters.getter(ActionParameters::anchor)).setter(ActionParameters.setter(Builder::anchor)).constructor(ComponentProperty::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("anchor").build()}).build();
    private static final SdkField<Map<String, ComponentProperty>> FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("fields").getter(ActionParameters.getter(ActionParameters::fields)).setter(ActionParameters.setter(Builder::fields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fields").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ComponentProperty::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<ComponentProperty> GLOBAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("global").getter(ActionParameters.getter(ActionParameters::global)).setter(ActionParameters.setter(Builder::global)).constructor(ComponentProperty::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("global").build()}).build();
    private static final SdkField<ComponentProperty> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("id").getter(ActionParameters.getter(ActionParameters::id)).setter(ActionParameters.setter(Builder::id)).constructor(ComponentProperty::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("model").getter(ActionParameters.getter(ActionParameters::model)).setter(ActionParameters.setter(Builder::model)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("model").build()}).build();
    private static final SdkField<MutationActionSetStateParameter> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("state").getter(ActionParameters.getter(ActionParameters::state)).setter(ActionParameters.setter(Builder::state)).constructor(MutationActionSetStateParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<ComponentProperty> TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("target").getter(ActionParameters.getter(ActionParameters::target)).setter(ActionParameters.setter(Builder::target)).constructor(ComponentProperty::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("target").build()}).build();
    private static final SdkField<ComponentProperty> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("type").getter(ActionParameters.getter(ActionParameters::type)).setter(ActionParameters.setter(Builder::type)).constructor(ComponentProperty::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<ComponentProperty> URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("url").getter(ActionParameters.getter(ActionParameters::url)).setter(ActionParameters.setter(Builder::url)).constructor(ComponentProperty::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("url").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANCHOR_FIELD, FIELDS_FIELD, GLOBAL_FIELD, ID_FIELD, MODEL_FIELD, STATE_FIELD, TARGET_FIELD, TYPE_FIELD, URL_FIELD));
    private static final long serialVersionUID = 1L;
    private final ComponentProperty anchor;
    private final Map<String, ComponentProperty> fields;
    private final ComponentProperty global;
    private final ComponentProperty id;
    private final String model;
    private final MutationActionSetStateParameter state;
    private final ComponentProperty target;
    private final ComponentProperty type;
    private final ComponentProperty url;

    private ActionParameters(BuilderImpl builder) {
        this.anchor = builder.anchor;
        this.fields = builder.fields;
        this.global = builder.global;
        this.id = builder.id;
        this.model = builder.model;
        this.state = builder.state;
        this.target = builder.target;
        this.type = builder.type;
        this.url = builder.url;
    }

    public final ComponentProperty anchor() {
        return this.anchor;
    }

    public final boolean hasFields() {
        return this.fields != null && !(this.fields instanceof SdkAutoConstructMap);
    }

    public final Map<String, ComponentProperty> fields() {
        return this.fields;
    }

    public final ComponentProperty global() {
        return this.global;
    }

    public final ComponentProperty id() {
        return this.id;
    }

    public final String model() {
        return this.model;
    }

    public final MutationActionSetStateParameter state() {
        return this.state;
    }

    public final ComponentProperty target() {
        return this.target;
    }

    public final ComponentProperty type() {
        return this.type;
    }

    public final ComponentProperty url() {
        return this.url;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.anchor());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFields() ? this.fields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.global());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.model());
        hashCode = 31 * hashCode + Objects.hashCode(this.state());
        hashCode = 31 * hashCode + Objects.hashCode(this.target());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionParameters)) {
            return false;
        }
        ActionParameters other = (ActionParameters)obj;
        return Objects.equals(this.anchor(), other.anchor()) && this.hasFields() == other.hasFields() && Objects.equals(this.fields(), other.fields()) && Objects.equals(this.global(), other.global()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.model(), other.model()) && Objects.equals(this.state(), other.state()) && Objects.equals(this.target(), other.target()) && Objects.equals(this.type(), other.type()) && Objects.equals(this.url(), other.url());
    }

    public final String toString() {
        return ToString.builder((String)"ActionParameters").add("Anchor", (Object)this.anchor()).add("Fields", this.hasFields() ? this.fields() : null).add("Global", (Object)this.global()).add("Id", (Object)this.id()).add("Model", (Object)this.model()).add("State", (Object)this.state()).add("Target", (Object)this.target()).add("Type", (Object)this.type()).add("Url", (Object)this.url()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "anchor": {
                return Optional.ofNullable(clazz.cast(this.anchor()));
            }
            case "fields": {
                return Optional.ofNullable(clazz.cast(this.fields()));
            }
            case "global": {
                return Optional.ofNullable(clazz.cast(this.global()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "model": {
                return Optional.ofNullable(clazz.cast(this.model()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.state()));
            }
            case "target": {
                return Optional.ofNullable(clazz.cast(this.target()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "url": {
                return Optional.ofNullable(clazz.cast(this.url()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ActionParameters, T> g) {
        return obj -> g.apply((ActionParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ComponentProperty anchor;
        private Map<String, ComponentProperty> fields = DefaultSdkAutoConstructMap.getInstance();
        private ComponentProperty global;
        private ComponentProperty id;
        private String model;
        private MutationActionSetStateParameter state;
        private ComponentProperty target;
        private ComponentProperty type;
        private ComponentProperty url;

        private BuilderImpl() {
        }

        private BuilderImpl(ActionParameters model) {
            this.anchor(model.anchor);
            this.fields(model.fields);
            this.global(model.global);
            this.id(model.id);
            this.model(model.model);
            this.state(model.state);
            this.target(model.target);
            this.type(model.type);
            this.url(model.url);
        }

        public final ComponentProperty.Builder getAnchor() {
            return this.anchor != null ? this.anchor.toBuilder() : null;
        }

        public final void setAnchor(ComponentProperty.BuilderImpl anchor) {
            this.anchor = anchor != null ? anchor.build() : null;
        }

        @Override
        public final Builder anchor(ComponentProperty anchor) {
            this.anchor = anchor;
            return this;
        }

        public final Map<String, ComponentProperty.Builder> getFields() {
            Map<String, ComponentProperty.Builder> result = ComponentPropertiesCopier.copyToBuilder(this.fields);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setFields(Map<String, ComponentProperty.BuilderImpl> fields) {
            this.fields = ComponentPropertiesCopier.copyFromBuilder(fields);
        }

        @Override
        public final Builder fields(Map<String, ComponentProperty> fields) {
            this.fields = ComponentPropertiesCopier.copy(fields);
            return this;
        }

        public final ComponentProperty.Builder getGlobal() {
            return this.global != null ? this.global.toBuilder() : null;
        }

        public final void setGlobal(ComponentProperty.BuilderImpl global) {
            this.global = global != null ? global.build() : null;
        }

        @Override
        public final Builder global(ComponentProperty global) {
            this.global = global;
            return this;
        }

        public final ComponentProperty.Builder getId() {
            return this.id != null ? this.id.toBuilder() : null;
        }

        public final void setId(ComponentProperty.BuilderImpl id) {
            this.id = id != null ? id.build() : null;
        }

        @Override
        public final Builder id(ComponentProperty id) {
            this.id = id;
            return this;
        }

        public final String getModel() {
            return this.model;
        }

        public final void setModel(String model) {
            this.model = model;
        }

        @Override
        public final Builder model(String model) {
            this.model = model;
            return this;
        }

        public final MutationActionSetStateParameter.Builder getState() {
            return this.state != null ? this.state.toBuilder() : null;
        }

        public final void setState(MutationActionSetStateParameter.BuilderImpl state) {
            this.state = state != null ? state.build() : null;
        }

        @Override
        public final Builder state(MutationActionSetStateParameter state) {
            this.state = state;
            return this;
        }

        public final ComponentProperty.Builder getTarget() {
            return this.target != null ? this.target.toBuilder() : null;
        }

        public final void setTarget(ComponentProperty.BuilderImpl target) {
            this.target = target != null ? target.build() : null;
        }

        @Override
        public final Builder target(ComponentProperty target) {
            this.target = target;
            return this;
        }

        public final ComponentProperty.Builder getType() {
            return this.type != null ? this.type.toBuilder() : null;
        }

        public final void setType(ComponentProperty.BuilderImpl type) {
            this.type = type != null ? type.build() : null;
        }

        @Override
        public final Builder type(ComponentProperty type) {
            this.type = type;
            return this;
        }

        public final ComponentProperty.Builder getUrl() {
            return this.url != null ? this.url.toBuilder() : null;
        }

        public final void setUrl(ComponentProperty.BuilderImpl url) {
            this.url = url != null ? url.build() : null;
        }

        @Override
        public final Builder url(ComponentProperty url) {
            this.url = url;
            return this;
        }

        public ActionParameters build() {
            return new ActionParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ActionParameters> {
        public Builder anchor(ComponentProperty var1);

        default public Builder anchor(Consumer<ComponentProperty.Builder> anchor) {
            return this.anchor((ComponentProperty)((ComponentProperty.Builder)ComponentProperty.builder().applyMutation(anchor)).build());
        }

        public Builder fields(Map<String, ComponentProperty> var1);

        public Builder global(ComponentProperty var1);

        default public Builder global(Consumer<ComponentProperty.Builder> global) {
            return this.global((ComponentProperty)((ComponentProperty.Builder)ComponentProperty.builder().applyMutation(global)).build());
        }

        public Builder id(ComponentProperty var1);

        default public Builder id(Consumer<ComponentProperty.Builder> id) {
            return this.id((ComponentProperty)((ComponentProperty.Builder)ComponentProperty.builder().applyMutation(id)).build());
        }

        public Builder model(String var1);

        public Builder state(MutationActionSetStateParameter var1);

        default public Builder state(Consumer<MutationActionSetStateParameter.Builder> state) {
            return this.state((MutationActionSetStateParameter)((MutationActionSetStateParameter.Builder)MutationActionSetStateParameter.builder().applyMutation(state)).build());
        }

        public Builder target(ComponentProperty var1);

        default public Builder target(Consumer<ComponentProperty.Builder> target) {
            return this.target((ComponentProperty)((ComponentProperty.Builder)ComponentProperty.builder().applyMutation(target)).build());
        }

        public Builder type(ComponentProperty var1);

        default public Builder type(Consumer<ComponentProperty.Builder> type) {
            return this.type((ComponentProperty)((ComponentProperty.Builder)ComponentProperty.builder().applyMutation(type)).build());
        }

        public Builder url(ComponentProperty var1);

        default public Builder url(Consumer<ComponentProperty.Builder> url) {
            return this.url((ComponentProperty)((ComponentProperty.Builder)ComponentProperty.builder().applyMutation(url)).build());
        }
    }
}

