/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.amplifyuibuilder.model.AmplifyUiBuilderResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.Theme;
import software.amazon.awssdk.services.amplifyuibuilder.model.ThemeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExportThemesResponse
extends AmplifyUiBuilderResponse
implements ToCopyableBuilder<Builder, ExportThemesResponse> {
    private static final SdkField<List<Theme>> ENTITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("entities").getter(ExportThemesResponse.getter(ExportThemesResponse::entities)).setter(ExportThemesResponse.setter(Builder::entities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Theme::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITIES_FIELD));
    private final List<Theme> entities;

    private ExportThemesResponse(BuilderImpl builder) {
        super(builder);
        this.entities = builder.entities;
    }

    public final boolean hasEntities() {
        return this.entities != null && !(this.entities instanceof SdkAutoConstructList);
    }

    public final List<Theme> entities() {
        return this.entities;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEntities() ? this.entities() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportThemesResponse)) {
            return false;
        }
        ExportThemesResponse other = (ExportThemesResponse)((Object)obj);
        return this.hasEntities() == other.hasEntities() && Objects.equals(this.entities(), other.entities());
    }

    public final String toString() {
        return ToString.builder((String)"ExportThemesResponse").add("Entities", this.hasEntities() ? this.entities() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "entities": {
                return Optional.ofNullable(clazz.cast(this.entities()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExportThemesResponse, T> g) {
        return obj -> g.apply((ExportThemesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AmplifyUiBuilderResponse.BuilderImpl
    implements Builder {
        private List<Theme> entities = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ExportThemesResponse model) {
            super(model);
            this.entities(model.entities);
        }

        public final List<Theme.Builder> getEntities() {
            List<Theme.Builder> result = ThemeListCopier.copyToBuilder(this.entities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntities(Collection<Theme.BuilderImpl> entities) {
            this.entities = ThemeListCopier.copyFromBuilder(entities);
        }

        @Override
        @Transient
        public final Builder entities(Collection<Theme> entities) {
            this.entities = ThemeListCopier.copy(entities);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder entities(Theme ... entities) {
            this.entities(Arrays.asList(entities));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder entities(Consumer<Theme.Builder> ... entities) {
            this.entities(Stream.of(entities).map(c -> (Theme)((Theme.Builder)Theme.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ExportThemesResponse build() {
            return new ExportThemesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AmplifyUiBuilderResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ExportThemesResponse> {
        public Builder entities(Collection<Theme> var1);

        public Builder entities(Theme ... var1);

        public Builder entities(Consumer<Theme.Builder> ... var1);
    }
}

