/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifybackend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The OAuth configurations for authenticating users into your Amplify app.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateBackendAuthOAuthConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdateBackendAuthOAuthConfig.Builder, UpdateBackendAuthOAuthConfig> {
    private static final SdkField<String> DOMAIN_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainPrefix").getter(getter(UpdateBackendAuthOAuthConfig::domainPrefix))
            .setter(setter(Builder::domainPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainPrefix").build()).build();

    private static final SdkField<String> O_AUTH_GRANT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OAuthGrantType").getter(getter(UpdateBackendAuthOAuthConfig::oAuthGrantTypeAsString))
            .setter(setter(Builder::oAuthGrantType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oAuthGrantType").build()).build();

    private static final SdkField<List<String>> O_AUTH_SCOPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("OAuthScopes")
            .getter(getter(UpdateBackendAuthOAuthConfig::oAuthScopesAsStrings))
            .setter(setter(Builder::oAuthScopesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oAuthScopes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> REDIRECT_SIGN_IN_UR_IS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RedirectSignInURIs")
            .getter(getter(UpdateBackendAuthOAuthConfig::redirectSignInURIs))
            .setter(setter(Builder::redirectSignInURIs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("redirectSignInURIs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> REDIRECT_SIGN_OUT_UR_IS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RedirectSignOutURIs")
            .getter(getter(UpdateBackendAuthOAuthConfig::redirectSignOutURIs))
            .setter(setter(Builder::redirectSignOutURIs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("redirectSignOutURIs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<SocialProviderSettings> SOCIAL_PROVIDER_SETTINGS_FIELD = SdkField
            .<SocialProviderSettings> builder(MarshallingType.SDK_POJO).memberName("SocialProviderSettings")
            .getter(getter(UpdateBackendAuthOAuthConfig::socialProviderSettings)).setter(setter(Builder::socialProviderSettings))
            .constructor(SocialProviderSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("socialProviderSettings").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_PREFIX_FIELD,
            O_AUTH_GRANT_TYPE_FIELD, O_AUTH_SCOPES_FIELD, REDIRECT_SIGN_IN_UR_IS_FIELD, REDIRECT_SIGN_OUT_UR_IS_FIELD,
            SOCIAL_PROVIDER_SETTINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String domainPrefix;

    private final String oAuthGrantType;

    private final List<String> oAuthScopes;

    private final List<String> redirectSignInURIs;

    private final List<String> redirectSignOutURIs;

    private final SocialProviderSettings socialProviderSettings;

    private UpdateBackendAuthOAuthConfig(BuilderImpl builder) {
        this.domainPrefix = builder.domainPrefix;
        this.oAuthGrantType = builder.oAuthGrantType;
        this.oAuthScopes = builder.oAuthScopes;
        this.redirectSignInURIs = builder.redirectSignInURIs;
        this.redirectSignOutURIs = builder.redirectSignOutURIs;
        this.socialProviderSettings = builder.socialProviderSettings;
    }

    /**
     * <p>
     * The Amazon Cognito domain prefix used to create a hosted UI for authentication.
     * </p>
     * 
     * @return The Amazon Cognito domain prefix used to create a hosted UI for authentication.
     */
    public final String domainPrefix() {
        return domainPrefix;
    }

    /**
     * <p>
     * The OAuth grant type to allow app users to authenticate from your Amplify app.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #oAuthGrantType}
     * will return {@link OAuthGrantType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #oAuthGrantTypeAsString}.
     * </p>
     * 
     * @return The OAuth grant type to allow app users to authenticate from your Amplify app.
     * @see OAuthGrantType
     */
    public final OAuthGrantType oAuthGrantType() {
        return OAuthGrantType.fromValue(oAuthGrantType);
    }

    /**
     * <p>
     * The OAuth grant type to allow app users to authenticate from your Amplify app.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #oAuthGrantType}
     * will return {@link OAuthGrantType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #oAuthGrantTypeAsString}.
     * </p>
     * 
     * @return The OAuth grant type to allow app users to authenticate from your Amplify app.
     * @see OAuthGrantType
     */
    public final String oAuthGrantTypeAsString() {
        return oAuthGrantType;
    }

    /**
     * <p>
     * The list of OAuth-related flows that can allow users to authenticate from your Amplify app.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasOAuthScopes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of OAuth-related flows that can allow users to authenticate from your Amplify app.
     */
    public final List<OAuthScopesElement> oAuthScopes() {
        return ListOfOAuthScopesElementCopier.copyStringToEnum(oAuthScopes);
    }

    /**
     * Returns true if the OAuthScopes property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasOAuthScopes() {
        return oAuthScopes != null && !(oAuthScopes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of OAuth-related flows that can allow users to authenticate from your Amplify app.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasOAuthScopes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of OAuth-related flows that can allow users to authenticate from your Amplify app.
     */
    public final List<String> oAuthScopesAsStrings() {
        return oAuthScopes;
    }

    /**
     * Returns true if the RedirectSignInURIs property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasRedirectSignInURIs() {
        return redirectSignInURIs != null && !(redirectSignInURIs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Redirect URLs that OAuth uses when a user signs in to an Amplify app.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRedirectSignInURIs()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Redirect URLs that OAuth uses when a user signs in to an Amplify app.
     */
    public final List<String> redirectSignInURIs() {
        return redirectSignInURIs;
    }

    /**
     * Returns true if the RedirectSignOutURIs property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasRedirectSignOutURIs() {
        return redirectSignOutURIs != null && !(redirectSignOutURIs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Redirect URLs that OAuth uses when a user signs out of an Amplify app.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRedirectSignOutURIs()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Redirect URLs that OAuth uses when a user signs out of an Amplify app.
     */
    public final List<String> redirectSignOutURIs() {
        return redirectSignOutURIs;
    }

    /**
     * <p>
     * Describes third-party social federation configurations for allowing your users to sign in with OAuth.
     * </p>
     * 
     * @return Describes third-party social federation configurations for allowing your users to sign in with OAuth.
     */
    public final SocialProviderSettings socialProviderSettings() {
        return socialProviderSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domainPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(oAuthGrantTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasOAuthScopes() ? oAuthScopesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRedirectSignInURIs() ? redirectSignInURIs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRedirectSignOutURIs() ? redirectSignOutURIs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(socialProviderSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBackendAuthOAuthConfig)) {
            return false;
        }
        UpdateBackendAuthOAuthConfig other = (UpdateBackendAuthOAuthConfig) obj;
        return Objects.equals(domainPrefix(), other.domainPrefix())
                && Objects.equals(oAuthGrantTypeAsString(), other.oAuthGrantTypeAsString())
                && hasOAuthScopes() == other.hasOAuthScopes()
                && Objects.equals(oAuthScopesAsStrings(), other.oAuthScopesAsStrings())
                && hasRedirectSignInURIs() == other.hasRedirectSignInURIs()
                && Objects.equals(redirectSignInURIs(), other.redirectSignInURIs())
                && hasRedirectSignOutURIs() == other.hasRedirectSignOutURIs()
                && Objects.equals(redirectSignOutURIs(), other.redirectSignOutURIs())
                && Objects.equals(socialProviderSettings(), other.socialProviderSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateBackendAuthOAuthConfig").add("DomainPrefix", domainPrefix())
                .add("OAuthGrantType", oAuthGrantTypeAsString())
                .add("OAuthScopes", hasOAuthScopes() ? oAuthScopesAsStrings() : null)
                .add("RedirectSignInURIs", hasRedirectSignInURIs() ? redirectSignInURIs() : null)
                .add("RedirectSignOutURIs", hasRedirectSignOutURIs() ? redirectSignOutURIs() : null)
                .add("SocialProviderSettings", socialProviderSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainPrefix":
            return Optional.ofNullable(clazz.cast(domainPrefix()));
        case "OAuthGrantType":
            return Optional.ofNullable(clazz.cast(oAuthGrantTypeAsString()));
        case "OAuthScopes":
            return Optional.ofNullable(clazz.cast(oAuthScopesAsStrings()));
        case "RedirectSignInURIs":
            return Optional.ofNullable(clazz.cast(redirectSignInURIs()));
        case "RedirectSignOutURIs":
            return Optional.ofNullable(clazz.cast(redirectSignOutURIs()));
        case "SocialProviderSettings":
            return Optional.ofNullable(clazz.cast(socialProviderSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateBackendAuthOAuthConfig, T> g) {
        return obj -> g.apply((UpdateBackendAuthOAuthConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateBackendAuthOAuthConfig> {
        /**
         * <p>
         * The Amazon Cognito domain prefix used to create a hosted UI for authentication.
         * </p>
         * 
         * @param domainPrefix
         *        The Amazon Cognito domain prefix used to create a hosted UI for authentication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainPrefix(String domainPrefix);

        /**
         * <p>
         * The OAuth grant type to allow app users to authenticate from your Amplify app.
         * </p>
         * 
         * @param oAuthGrantType
         *        The OAuth grant type to allow app users to authenticate from your Amplify app.
         * @see OAuthGrantType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OAuthGrantType
         */
        Builder oAuthGrantType(String oAuthGrantType);

        /**
         * <p>
         * The OAuth grant type to allow app users to authenticate from your Amplify app.
         * </p>
         * 
         * @param oAuthGrantType
         *        The OAuth grant type to allow app users to authenticate from your Amplify app.
         * @see OAuthGrantType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OAuthGrantType
         */
        Builder oAuthGrantType(OAuthGrantType oAuthGrantType);

        /**
         * <p>
         * The list of OAuth-related flows that can allow users to authenticate from your Amplify app.
         * </p>
         * 
         * @param oAuthScopes
         *        The list of OAuth-related flows that can allow users to authenticate from your Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oAuthScopesWithStrings(Collection<String> oAuthScopes);

        /**
         * <p>
         * The list of OAuth-related flows that can allow users to authenticate from your Amplify app.
         * </p>
         * 
         * @param oAuthScopes
         *        The list of OAuth-related flows that can allow users to authenticate from your Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oAuthScopesWithStrings(String... oAuthScopes);

        /**
         * <p>
         * The list of OAuth-related flows that can allow users to authenticate from your Amplify app.
         * </p>
         * 
         * @param oAuthScopes
         *        The list of OAuth-related flows that can allow users to authenticate from your Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oAuthScopes(Collection<OAuthScopesElement> oAuthScopes);

        /**
         * <p>
         * The list of OAuth-related flows that can allow users to authenticate from your Amplify app.
         * </p>
         * 
         * @param oAuthScopes
         *        The list of OAuth-related flows that can allow users to authenticate from your Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oAuthScopes(OAuthScopesElement... oAuthScopes);

        /**
         * <p>
         * Redirect URLs that OAuth uses when a user signs in to an Amplify app.
         * </p>
         * 
         * @param redirectSignInURIs
         *        Redirect URLs that OAuth uses when a user signs in to an Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redirectSignInURIs(Collection<String> redirectSignInURIs);

        /**
         * <p>
         * Redirect URLs that OAuth uses when a user signs in to an Amplify app.
         * </p>
         * 
         * @param redirectSignInURIs
         *        Redirect URLs that OAuth uses when a user signs in to an Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redirectSignInURIs(String... redirectSignInURIs);

        /**
         * <p>
         * Redirect URLs that OAuth uses when a user signs out of an Amplify app.
         * </p>
         * 
         * @param redirectSignOutURIs
         *        Redirect URLs that OAuth uses when a user signs out of an Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redirectSignOutURIs(Collection<String> redirectSignOutURIs);

        /**
         * <p>
         * Redirect URLs that OAuth uses when a user signs out of an Amplify app.
         * </p>
         * 
         * @param redirectSignOutURIs
         *        Redirect URLs that OAuth uses when a user signs out of an Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redirectSignOutURIs(String... redirectSignOutURIs);

        /**
         * <p>
         * Describes third-party social federation configurations for allowing your users to sign in with OAuth.
         * </p>
         * 
         * @param socialProviderSettings
         *        Describes third-party social federation configurations for allowing your users to sign in with OAuth.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder socialProviderSettings(SocialProviderSettings socialProviderSettings);

        /**
         * <p>
         * Describes third-party social federation configurations for allowing your users to sign in with OAuth.
         * </p>
         * This is a convenience that creates an instance of the {@link SocialProviderSettings.Builder} avoiding the
         * need to create one manually via {@link SocialProviderSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link SocialProviderSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #socialProviderSettings(SocialProviderSettings)}.
         * 
         * @param socialProviderSettings
         *        a consumer that will call methods on {@link SocialProviderSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #socialProviderSettings(SocialProviderSettings)
         */
        default Builder socialProviderSettings(Consumer<SocialProviderSettings.Builder> socialProviderSettings) {
            return socialProviderSettings(SocialProviderSettings.builder().applyMutation(socialProviderSettings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String domainPrefix;

        private String oAuthGrantType;

        private List<String> oAuthScopes = DefaultSdkAutoConstructList.getInstance();

        private List<String> redirectSignInURIs = DefaultSdkAutoConstructList.getInstance();

        private List<String> redirectSignOutURIs = DefaultSdkAutoConstructList.getInstance();

        private SocialProviderSettings socialProviderSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBackendAuthOAuthConfig model) {
            domainPrefix(model.domainPrefix);
            oAuthGrantType(model.oAuthGrantType);
            oAuthScopesWithStrings(model.oAuthScopes);
            redirectSignInURIs(model.redirectSignInURIs);
            redirectSignOutURIs(model.redirectSignOutURIs);
            socialProviderSettings(model.socialProviderSettings);
        }

        public final String getDomainPrefix() {
            return domainPrefix;
        }

        @Override
        public final Builder domainPrefix(String domainPrefix) {
            this.domainPrefix = domainPrefix;
            return this;
        }

        public final void setDomainPrefix(String domainPrefix) {
            this.domainPrefix = domainPrefix;
        }

        public final String getOAuthGrantType() {
            return oAuthGrantType;
        }

        @Override
        public final Builder oAuthGrantType(String oAuthGrantType) {
            this.oAuthGrantType = oAuthGrantType;
            return this;
        }

        @Override
        public final Builder oAuthGrantType(OAuthGrantType oAuthGrantType) {
            this.oAuthGrantType(oAuthGrantType == null ? null : oAuthGrantType.toString());
            return this;
        }

        public final void setOAuthGrantType(String oAuthGrantType) {
            this.oAuthGrantType = oAuthGrantType;
        }

        public final Collection<String> getOAuthScopes() {
            if (oAuthScopes instanceof SdkAutoConstructList) {
                return null;
            }
            return oAuthScopes;
        }

        @Override
        public final Builder oAuthScopesWithStrings(Collection<String> oAuthScopes) {
            this.oAuthScopes = ListOfOAuthScopesElementCopier.copy(oAuthScopes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder oAuthScopesWithStrings(String... oAuthScopes) {
            oAuthScopesWithStrings(Arrays.asList(oAuthScopes));
            return this;
        }

        @Override
        public final Builder oAuthScopes(Collection<OAuthScopesElement> oAuthScopes) {
            this.oAuthScopes = ListOfOAuthScopesElementCopier.copyEnumToString(oAuthScopes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder oAuthScopes(OAuthScopesElement... oAuthScopes) {
            oAuthScopes(Arrays.asList(oAuthScopes));
            return this;
        }

        public final void setOAuthScopes(Collection<String> oAuthScopes) {
            this.oAuthScopes = ListOfOAuthScopesElementCopier.copy(oAuthScopes);
        }

        public final Collection<String> getRedirectSignInURIs() {
            if (redirectSignInURIs instanceof SdkAutoConstructList) {
                return null;
            }
            return redirectSignInURIs;
        }

        @Override
        public final Builder redirectSignInURIs(Collection<String> redirectSignInURIs) {
            this.redirectSignInURIs = ListOf__stringCopier.copy(redirectSignInURIs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder redirectSignInURIs(String... redirectSignInURIs) {
            redirectSignInURIs(Arrays.asList(redirectSignInURIs));
            return this;
        }

        public final void setRedirectSignInURIs(Collection<String> redirectSignInURIs) {
            this.redirectSignInURIs = ListOf__stringCopier.copy(redirectSignInURIs);
        }

        public final Collection<String> getRedirectSignOutURIs() {
            if (redirectSignOutURIs instanceof SdkAutoConstructList) {
                return null;
            }
            return redirectSignOutURIs;
        }

        @Override
        public final Builder redirectSignOutURIs(Collection<String> redirectSignOutURIs) {
            this.redirectSignOutURIs = ListOf__stringCopier.copy(redirectSignOutURIs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder redirectSignOutURIs(String... redirectSignOutURIs) {
            redirectSignOutURIs(Arrays.asList(redirectSignOutURIs));
            return this;
        }

        public final void setRedirectSignOutURIs(Collection<String> redirectSignOutURIs) {
            this.redirectSignOutURIs = ListOf__stringCopier.copy(redirectSignOutURIs);
        }

        public final SocialProviderSettings.Builder getSocialProviderSettings() {
            return socialProviderSettings != null ? socialProviderSettings.toBuilder() : null;
        }

        @Override
        public final Builder socialProviderSettings(SocialProviderSettings socialProviderSettings) {
            this.socialProviderSettings = socialProviderSettings;
            return this;
        }

        public final void setSocialProviderSettings(SocialProviderSettings.BuilderImpl socialProviderSettings) {
            this.socialProviderSettings = socialProviderSettings != null ? socialProviderSettings.build() : null;
        }

        @Override
        public UpdateBackendAuthOAuthConfig build() {
            return new UpdateBackendAuthOAuthConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
