/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifybackend.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetBackendApiResponse extends AmplifyBackendResponse implements
        ToCopyableBuilder<GetBackendApiResponse.Builder, GetBackendApiResponse> {
    private static final SdkField<String> APP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("AppId")
            .getter(getter(GetBackendApiResponse::appId)).setter(setter(Builder::appId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appId").build()).build();

    private static final SdkField<String> BACKEND_ENVIRONMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackendEnvironmentName").getter(getter(GetBackendApiResponse::backendEnvironmentName))
            .setter(setter(Builder::backendEnvironmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("backendEnvironmentName").build())
            .build();

    private static final SdkField<String> ERROR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Error")
            .getter(getter(GetBackendApiResponse::error)).setter(setter(Builder::error))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()).build();

    private static final SdkField<BackendAPIResourceConfig> RESOURCE_CONFIG_FIELD = SdkField
            .<BackendAPIResourceConfig> builder(MarshallingType.SDK_POJO).memberName("ResourceConfig")
            .getter(getter(GetBackendApiResponse::resourceConfig)).setter(setter(Builder::resourceConfig))
            .constructor(BackendAPIResourceConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceConfig").build()).build();

    private static final SdkField<String> RESOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceName").getter(getter(GetBackendApiResponse::resourceName)).setter(setter(Builder::resourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ID_FIELD,
            BACKEND_ENVIRONMENT_NAME_FIELD, ERROR_FIELD, RESOURCE_CONFIG_FIELD, RESOURCE_NAME_FIELD));

    private final String appId;

    private final String backendEnvironmentName;

    private final String error;

    private final BackendAPIResourceConfig resourceConfig;

    private final String resourceName;

    private GetBackendApiResponse(BuilderImpl builder) {
        super(builder);
        this.appId = builder.appId;
        this.backendEnvironmentName = builder.backendEnvironmentName;
        this.error = builder.error;
        this.resourceConfig = builder.resourceConfig;
        this.resourceName = builder.resourceName;
    }

    /**
     * <p>
     * The app ID.
     * </p>
     * 
     * @return The app ID.
     */
    public final String appId() {
        return appId;
    }

    /**
     * <p>
     * The name of the backend environment.
     * </p>
     * 
     * @return The name of the backend environment.
     */
    public final String backendEnvironmentName() {
        return backendEnvironmentName;
    }

    /**
     * <p>
     * If the request failed, this is the returned error.
     * </p>
     * 
     * @return If the request failed, this is the returned error.
     */
    public final String error() {
        return error;
    }

    /**
     * <p>
     * The resource configuration for this response object.
     * </p>
     * 
     * @return The resource configuration for this response object.
     */
    public final BackendAPIResourceConfig resourceConfig() {
        return resourceConfig;
    }

    /**
     * <p>
     * The name of this resource.
     * </p>
     * 
     * @return The name of this resource.
     */
    public final String resourceName() {
        return resourceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appId());
        hashCode = 31 * hashCode + Objects.hashCode(backendEnvironmentName());
        hashCode = 31 * hashCode + Objects.hashCode(error());
        hashCode = 31 * hashCode + Objects.hashCode(resourceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(resourceName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBackendApiResponse)) {
            return false;
        }
        GetBackendApiResponse other = (GetBackendApiResponse) obj;
        return Objects.equals(appId(), other.appId()) && Objects.equals(backendEnvironmentName(), other.backendEnvironmentName())
                && Objects.equals(error(), other.error()) && Objects.equals(resourceConfig(), other.resourceConfig())
                && Objects.equals(resourceName(), other.resourceName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetBackendApiResponse").add("AppId", appId())
                .add("BackendEnvironmentName", backendEnvironmentName()).add("Error", error())
                .add("ResourceConfig", resourceConfig()).add("ResourceName", resourceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AppId":
            return Optional.ofNullable(clazz.cast(appId()));
        case "BackendEnvironmentName":
            return Optional.ofNullable(clazz.cast(backendEnvironmentName()));
        case "Error":
            return Optional.ofNullable(clazz.cast(error()));
        case "ResourceConfig":
            return Optional.ofNullable(clazz.cast(resourceConfig()));
        case "ResourceName":
            return Optional.ofNullable(clazz.cast(resourceName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetBackendApiResponse, T> g) {
        return obj -> g.apply((GetBackendApiResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AmplifyBackendResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetBackendApiResponse> {
        /**
         * <p>
         * The app ID.
         * </p>
         * 
         * @param appId
         *        The app ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appId(String appId);

        /**
         * <p>
         * The name of the backend environment.
         * </p>
         * 
         * @param backendEnvironmentName
         *        The name of the backend environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backendEnvironmentName(String backendEnvironmentName);

        /**
         * <p>
         * If the request failed, this is the returned error.
         * </p>
         * 
         * @param error
         *        If the request failed, this is the returned error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(String error);

        /**
         * <p>
         * The resource configuration for this response object.
         * </p>
         * 
         * @param resourceConfig
         *        The resource configuration for this response object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceConfig(BackendAPIResourceConfig resourceConfig);

        /**
         * <p>
         * The resource configuration for this response object.
         * </p>
         * This is a convenience that creates an instance of the {@link BackendAPIResourceConfig.Builder} avoiding the
         * need to create one manually via {@link BackendAPIResourceConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link BackendAPIResourceConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #resourceConfig(BackendAPIResourceConfig)}.
         * 
         * @param resourceConfig
         *        a consumer that will call methods on {@link BackendAPIResourceConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceConfig(BackendAPIResourceConfig)
         */
        default Builder resourceConfig(Consumer<BackendAPIResourceConfig.Builder> resourceConfig) {
            return resourceConfig(BackendAPIResourceConfig.builder().applyMutation(resourceConfig).build());
        }

        /**
         * <p>
         * The name of this resource.
         * </p>
         * 
         * @param resourceName
         *        The name of this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceName(String resourceName);
    }

    static final class BuilderImpl extends AmplifyBackendResponse.BuilderImpl implements Builder {
        private String appId;

        private String backendEnvironmentName;

        private String error;

        private BackendAPIResourceConfig resourceConfig;

        private String resourceName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBackendApiResponse model) {
            super(model);
            appId(model.appId);
            backendEnvironmentName(model.backendEnvironmentName);
            error(model.error);
            resourceConfig(model.resourceConfig);
            resourceName(model.resourceName);
        }

        public final String getAppId() {
            return appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        public final String getBackendEnvironmentName() {
            return backendEnvironmentName;
        }

        @Override
        public final Builder backendEnvironmentName(String backendEnvironmentName) {
            this.backendEnvironmentName = backendEnvironmentName;
            return this;
        }

        public final void setBackendEnvironmentName(String backendEnvironmentName) {
            this.backendEnvironmentName = backendEnvironmentName;
        }

        public final String getError() {
            return error;
        }

        @Override
        public final Builder error(String error) {
            this.error = error;
            return this;
        }

        public final void setError(String error) {
            this.error = error;
        }

        public final BackendAPIResourceConfig.Builder getResourceConfig() {
            return resourceConfig != null ? resourceConfig.toBuilder() : null;
        }

        @Override
        public final Builder resourceConfig(BackendAPIResourceConfig resourceConfig) {
            this.resourceConfig = resourceConfig;
            return this;
        }

        public final void setResourceConfig(BackendAPIResourceConfig.BuilderImpl resourceConfig) {
            this.resourceConfig = resourceConfig != null ? resourceConfig.build() : null;
        }

        public final String getResourceName() {
            return resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        @Override
        public GetBackendApiResponse build() {
            return new GetBackendApiResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
