/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplify.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Webhook
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Webhook> {
    private static final SdkField<String> WEBHOOK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Webhook.getter(Webhook::webhookArn)).setter(Webhook.setter(Builder::webhookArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("webhookArn").build()}).build();
    private static final SdkField<String> WEBHOOK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Webhook.getter(Webhook::webhookId)).setter(Webhook.setter(Builder::webhookId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("webhookId").build()}).build();
    private static final SdkField<String> WEBHOOK_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Webhook.getter(Webhook::webhookUrl)).setter(Webhook.setter(Builder::webhookUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("webhookUrl").build()}).build();
    private static final SdkField<String> BRANCH_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Webhook.getter(Webhook::branchName)).setter(Webhook.setter(Builder::branchName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("branchName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Webhook.getter(Webhook::description)).setter(Webhook.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(Webhook.getter(Webhook::createTime)).setter(Webhook.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build()}).build();
    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(Webhook.getter(Webhook::updateTime)).setter(Webhook.setter(Builder::updateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WEBHOOK_ARN_FIELD, WEBHOOK_ID_FIELD, WEBHOOK_URL_FIELD, BRANCH_NAME_FIELD, DESCRIPTION_FIELD, CREATE_TIME_FIELD, UPDATE_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String webhookArn;
    private final String webhookId;
    private final String webhookUrl;
    private final String branchName;
    private final String description;
    private final Instant createTime;
    private final Instant updateTime;

    private Webhook(BuilderImpl builder) {
        this.webhookArn = builder.webhookArn;
        this.webhookId = builder.webhookId;
        this.webhookUrl = builder.webhookUrl;
        this.branchName = builder.branchName;
        this.description = builder.description;
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
    }

    public String webhookArn() {
        return this.webhookArn;
    }

    public String webhookId() {
        return this.webhookId;
    }

    public String webhookUrl() {
        return this.webhookUrl;
    }

    public String branchName() {
        return this.branchName;
    }

    public String description() {
        return this.description;
    }

    public Instant createTime() {
        return this.createTime;
    }

    public Instant updateTime() {
        return this.updateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.webhookArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.webhookId());
        hashCode = 31 * hashCode + Objects.hashCode(this.webhookUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.branchName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Webhook)) {
            return false;
        }
        Webhook other = (Webhook)obj;
        return Objects.equals(this.webhookArn(), other.webhookArn()) && Objects.equals(this.webhookId(), other.webhookId()) && Objects.equals(this.webhookUrl(), other.webhookUrl()) && Objects.equals(this.branchName(), other.branchName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.updateTime(), other.updateTime());
    }

    public String toString() {
        return ToString.builder((String)"Webhook").add("WebhookArn", (Object)this.webhookArn()).add("WebhookId", (Object)this.webhookId()).add("WebhookUrl", (Object)this.webhookUrl()).add("BranchName", (Object)this.branchName()).add("Description", (Object)this.description()).add("CreateTime", (Object)this.createTime()).add("UpdateTime", (Object)this.updateTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "webhookArn": {
                return Optional.ofNullable(clazz.cast(this.webhookArn()));
            }
            case "webhookId": {
                return Optional.ofNullable(clazz.cast(this.webhookId()));
            }
            case "webhookUrl": {
                return Optional.ofNullable(clazz.cast(this.webhookUrl()));
            }
            case "branchName": {
                return Optional.ofNullable(clazz.cast(this.branchName()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "createTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "updateTime": {
                return Optional.ofNullable(clazz.cast(this.updateTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Webhook, T> g) {
        return obj -> g.apply((Webhook)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String webhookArn;
        private String webhookId;
        private String webhookUrl;
        private String branchName;
        private String description;
        private Instant createTime;
        private Instant updateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(Webhook model) {
            this.webhookArn(model.webhookArn);
            this.webhookId(model.webhookId);
            this.webhookUrl(model.webhookUrl);
            this.branchName(model.branchName);
            this.description(model.description);
            this.createTime(model.createTime);
            this.updateTime(model.updateTime);
        }

        public final String getWebhookArn() {
            return this.webhookArn;
        }

        @Override
        public final Builder webhookArn(String webhookArn) {
            this.webhookArn = webhookArn;
            return this;
        }

        public final void setWebhookArn(String webhookArn) {
            this.webhookArn = webhookArn;
        }

        public final String getWebhookId() {
            return this.webhookId;
        }

        @Override
        public final Builder webhookId(String webhookId) {
            this.webhookId = webhookId;
            return this;
        }

        public final void setWebhookId(String webhookId) {
            this.webhookId = webhookId;
        }

        public final String getWebhookUrl() {
            return this.webhookUrl;
        }

        @Override
        public final Builder webhookUrl(String webhookUrl) {
            this.webhookUrl = webhookUrl;
            return this;
        }

        public final void setWebhookUrl(String webhookUrl) {
            this.webhookUrl = webhookUrl;
        }

        public final String getBranchName() {
            return this.branchName;
        }

        @Override
        public final Builder branchName(String branchName) {
            this.branchName = branchName;
            return this;
        }

        public final void setBranchName(String branchName) {
            this.branchName = branchName;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        public final Instant getUpdateTime() {
            return this.updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        public Webhook build() {
            return new Webhook(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Webhook> {
        public Builder webhookArn(String var1);

        public Builder webhookId(String var1);

        public Builder webhookUrl(String var1);

        public Builder branchName(String var1);

        public Builder description(String var1);

        public Builder createTime(Instant var1);

        public Builder updateTime(Instant var1);
    }
}

