/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplify;

import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.amplify.AmplifyClient;
import software.amazon.awssdk.services.amplify.AmplifyServiceClientConfiguration;
import software.amazon.awssdk.services.amplify.internal.AmplifyServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.amplify.model.AmplifyException;
import software.amazon.awssdk.services.amplify.model.BadRequestException;
import software.amazon.awssdk.services.amplify.model.CreateAppRequest;
import software.amazon.awssdk.services.amplify.model.CreateAppResponse;
import software.amazon.awssdk.services.amplify.model.CreateBackendEnvironmentRequest;
import software.amazon.awssdk.services.amplify.model.CreateBackendEnvironmentResponse;
import software.amazon.awssdk.services.amplify.model.CreateBranchRequest;
import software.amazon.awssdk.services.amplify.model.CreateBranchResponse;
import software.amazon.awssdk.services.amplify.model.CreateDeploymentRequest;
import software.amazon.awssdk.services.amplify.model.CreateDeploymentResponse;
import software.amazon.awssdk.services.amplify.model.CreateDomainAssociationRequest;
import software.amazon.awssdk.services.amplify.model.CreateDomainAssociationResponse;
import software.amazon.awssdk.services.amplify.model.CreateWebhookRequest;
import software.amazon.awssdk.services.amplify.model.CreateWebhookResponse;
import software.amazon.awssdk.services.amplify.model.DeleteAppRequest;
import software.amazon.awssdk.services.amplify.model.DeleteAppResponse;
import software.amazon.awssdk.services.amplify.model.DeleteBackendEnvironmentRequest;
import software.amazon.awssdk.services.amplify.model.DeleteBackendEnvironmentResponse;
import software.amazon.awssdk.services.amplify.model.DeleteBranchRequest;
import software.amazon.awssdk.services.amplify.model.DeleteBranchResponse;
import software.amazon.awssdk.services.amplify.model.DeleteDomainAssociationRequest;
import software.amazon.awssdk.services.amplify.model.DeleteDomainAssociationResponse;
import software.amazon.awssdk.services.amplify.model.DeleteJobRequest;
import software.amazon.awssdk.services.amplify.model.DeleteJobResponse;
import software.amazon.awssdk.services.amplify.model.DeleteWebhookRequest;
import software.amazon.awssdk.services.amplify.model.DeleteWebhookResponse;
import software.amazon.awssdk.services.amplify.model.DependentServiceFailureException;
import software.amazon.awssdk.services.amplify.model.GenerateAccessLogsRequest;
import software.amazon.awssdk.services.amplify.model.GenerateAccessLogsResponse;
import software.amazon.awssdk.services.amplify.model.GetAppRequest;
import software.amazon.awssdk.services.amplify.model.GetAppResponse;
import software.amazon.awssdk.services.amplify.model.GetArtifactUrlRequest;
import software.amazon.awssdk.services.amplify.model.GetArtifactUrlResponse;
import software.amazon.awssdk.services.amplify.model.GetBackendEnvironmentRequest;
import software.amazon.awssdk.services.amplify.model.GetBackendEnvironmentResponse;
import software.amazon.awssdk.services.amplify.model.GetBranchRequest;
import software.amazon.awssdk.services.amplify.model.GetBranchResponse;
import software.amazon.awssdk.services.amplify.model.GetDomainAssociationRequest;
import software.amazon.awssdk.services.amplify.model.GetDomainAssociationResponse;
import software.amazon.awssdk.services.amplify.model.GetJobRequest;
import software.amazon.awssdk.services.amplify.model.GetJobResponse;
import software.amazon.awssdk.services.amplify.model.GetWebhookRequest;
import software.amazon.awssdk.services.amplify.model.GetWebhookResponse;
import software.amazon.awssdk.services.amplify.model.InternalFailureException;
import software.amazon.awssdk.services.amplify.model.LimitExceededException;
import software.amazon.awssdk.services.amplify.model.ListAppsRequest;
import software.amazon.awssdk.services.amplify.model.ListAppsResponse;
import software.amazon.awssdk.services.amplify.model.ListArtifactsRequest;
import software.amazon.awssdk.services.amplify.model.ListArtifactsResponse;
import software.amazon.awssdk.services.amplify.model.ListBackendEnvironmentsRequest;
import software.amazon.awssdk.services.amplify.model.ListBackendEnvironmentsResponse;
import software.amazon.awssdk.services.amplify.model.ListBranchesRequest;
import software.amazon.awssdk.services.amplify.model.ListBranchesResponse;
import software.amazon.awssdk.services.amplify.model.ListDomainAssociationsRequest;
import software.amazon.awssdk.services.amplify.model.ListDomainAssociationsResponse;
import software.amazon.awssdk.services.amplify.model.ListJobsRequest;
import software.amazon.awssdk.services.amplify.model.ListJobsResponse;
import software.amazon.awssdk.services.amplify.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.amplify.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.amplify.model.ListWebhooksRequest;
import software.amazon.awssdk.services.amplify.model.ListWebhooksResponse;
import software.amazon.awssdk.services.amplify.model.NotFoundException;
import software.amazon.awssdk.services.amplify.model.ResourceNotFoundException;
import software.amazon.awssdk.services.amplify.model.StartDeploymentRequest;
import software.amazon.awssdk.services.amplify.model.StartDeploymentResponse;
import software.amazon.awssdk.services.amplify.model.StartJobRequest;
import software.amazon.awssdk.services.amplify.model.StartJobResponse;
import software.amazon.awssdk.services.amplify.model.StopJobRequest;
import software.amazon.awssdk.services.amplify.model.StopJobResponse;
import software.amazon.awssdk.services.amplify.model.TagResourceRequest;
import software.amazon.awssdk.services.amplify.model.TagResourceResponse;
import software.amazon.awssdk.services.amplify.model.UnauthorizedException;
import software.amazon.awssdk.services.amplify.model.UntagResourceRequest;
import software.amazon.awssdk.services.amplify.model.UntagResourceResponse;
import software.amazon.awssdk.services.amplify.model.UpdateAppRequest;
import software.amazon.awssdk.services.amplify.model.UpdateAppResponse;
import software.amazon.awssdk.services.amplify.model.UpdateBranchRequest;
import software.amazon.awssdk.services.amplify.model.UpdateBranchResponse;
import software.amazon.awssdk.services.amplify.model.UpdateDomainAssociationRequest;
import software.amazon.awssdk.services.amplify.model.UpdateDomainAssociationResponse;
import software.amazon.awssdk.services.amplify.model.UpdateWebhookRequest;
import software.amazon.awssdk.services.amplify.model.UpdateWebhookResponse;
import software.amazon.awssdk.services.amplify.transform.CreateAppRequestMarshaller;
import software.amazon.awssdk.services.amplify.transform.CreateBackendEnvironmentRequestMarshaller;
import software.amazon.awssdk.services.amplify.transform.CreateBranchRequestMarshaller;
import software.amazon.awssdk.services.amplify.transform.CreateDeploymentRequestMarshaller;
import software.amazon.awssdk.services.amplify.transform.CreateDomainAssociationRequestMarshaller;
import software.amazon.awssdk.services.amplify.transform.CreateWebhookRequestMarshaller;
import software.amazon.awssdk.services.amplify.transform.DeleteAppRequestMarshaller;
import software.amazon.awssdk.services.amplify.transform.DeleteBackendEnvironmentRequestMarshaller;
import software.amazon.awssdk.services.amplify.transform.DeleteBranchRequestMarshaller;
import software.amazon.awssdk.services.amplify.transform.DeleteDomainAssociationRequestMarshaller;
import software.amazon.awssdk.services.amplify.transform.DeleteJobRequestMarshaller;
import software.amazon.awssdk.services.amplify.transform.DeleteWebhookRequestMarshaller;
import software.amazon.awssdk.services.amplify.transform.GenerateAccessLogsRequestMarshaller;
import software.amazon.awssdk.services.amplify.transform.GetAppRequestMarshaller;
import software.amazon.awssdk.services.amplify.transform.GetArtifactUrlRequestMarshaller;
import software.amazon.awssdk.services.amplify.transform.GetBackendEnvironmentRequestMarshaller;
import software.amazon.awssdk.services.amplify.transform.GetBranchRequestMarshaller;
import software.amazon.awssdk.services.amplify.transform.GetDomainAssociationRequestMarshaller;
import software.amazon.awssdk.services.amplify.transform.GetJobRequestMarshaller;
import software.amazon.awssdk.services.amplify.transform.GetWebhookRequestMarshaller;
import software.amazon.awssdk.services.amplify.transform.ListAppsRequestMarshaller;
import software.amazon.awssdk.services.amplify.transform.ListArtifactsRequestMarshaller;
import software.amazon.awssdk.services.amplify.transform.ListBackendEnvironmentsRequestMarshaller;
import software.amazon.awssdk.services.amplify.transform.ListBranchesRequestMarshaller;
import software.amazon.awssdk.services.amplify.transform.ListDomainAssociationsRequestMarshaller;
import software.amazon.awssdk.services.amplify.transform.ListJobsRequestMarshaller;
import software.amazon.awssdk.services.amplify.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.amplify.transform.ListWebhooksRequestMarshaller;
import software.amazon.awssdk.services.amplify.transform.StartDeploymentRequestMarshaller;
import software.amazon.awssdk.services.amplify.transform.StartJobRequestMarshaller;
import software.amazon.awssdk.services.amplify.transform.StopJobRequestMarshaller;
import software.amazon.awssdk.services.amplify.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.amplify.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.amplify.transform.UpdateAppRequestMarshaller;
import software.amazon.awssdk.services.amplify.transform.UpdateBranchRequestMarshaller;
import software.amazon.awssdk.services.amplify.transform.UpdateDomainAssociationRequestMarshaller;
import software.amazon.awssdk.services.amplify.transform.UpdateWebhookRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultAmplifyClient
implements AmplifyClient {
    private static final Logger log = Logger.loggerFor(DefaultAmplifyClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;
    private final AmplifyServiceClientConfiguration serviceClientConfiguration;

    protected DefaultAmplifyClient(AmplifyServiceClientConfiguration serviceClientConfiguration, SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.serviceClientConfiguration = serviceClientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateAppResponse createApp(CreateAppRequest createAppRequest) throws BadRequestException, UnauthorizedException, InternalFailureException, LimitExceededException, DependentServiceFailureException, AwsServiceException, SdkClientException, AmplifyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateAppResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createAppRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAmplifyClient.resolveMetricPublishers(clientConfiguration, createAppRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Amplify");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateApp");
            CreateAppResponse createAppResponse = (CreateAppResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateApp").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createAppRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateAppRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createAppResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAmplifyClient.lambda$createApp$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateBackendEnvironmentResponse createBackendEnvironment(CreateBackendEnvironmentRequest createBackendEnvironmentRequest) throws BadRequestException, UnauthorizedException, NotFoundException, InternalFailureException, LimitExceededException, AwsServiceException, SdkClientException, AmplifyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateBackendEnvironmentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createBackendEnvironmentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAmplifyClient.resolveMetricPublishers(clientConfiguration, createBackendEnvironmentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Amplify");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateBackendEnvironment");
            CreateBackendEnvironmentResponse createBackendEnvironmentResponse = (CreateBackendEnvironmentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateBackendEnvironment").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createBackendEnvironmentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateBackendEnvironmentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createBackendEnvironmentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAmplifyClient.lambda$createBackendEnvironment$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateBranchResponse createBranch(CreateBranchRequest createBranchRequest) throws BadRequestException, UnauthorizedException, NotFoundException, InternalFailureException, LimitExceededException, DependentServiceFailureException, AwsServiceException, SdkClientException, AmplifyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateBranchResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createBranchRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAmplifyClient.resolveMetricPublishers(clientConfiguration, createBranchRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Amplify");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateBranch");
            CreateBranchResponse createBranchResponse = (CreateBranchResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateBranch").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createBranchRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateBranchRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createBranchResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAmplifyClient.lambda$createBranch$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDeploymentResponse createDeployment(CreateDeploymentRequest createDeploymentRequest) throws BadRequestException, UnauthorizedException, InternalFailureException, LimitExceededException, AwsServiceException, SdkClientException, AmplifyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDeploymentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createDeploymentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAmplifyClient.resolveMetricPublishers(clientConfiguration, createDeploymentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Amplify");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDeployment");
            CreateDeploymentResponse createDeploymentResponse = (CreateDeploymentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDeployment").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createDeploymentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateDeploymentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createDeploymentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAmplifyClient.lambda$createDeployment$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDomainAssociationResponse createDomainAssociation(CreateDomainAssociationRequest createDomainAssociationRequest) throws BadRequestException, UnauthorizedException, NotFoundException, InternalFailureException, LimitExceededException, DependentServiceFailureException, AwsServiceException, SdkClientException, AmplifyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDomainAssociationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createDomainAssociationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAmplifyClient.resolveMetricPublishers(clientConfiguration, createDomainAssociationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Amplify");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDomainAssociation");
            CreateDomainAssociationResponse createDomainAssociationResponse = (CreateDomainAssociationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDomainAssociation").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createDomainAssociationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateDomainAssociationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createDomainAssociationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAmplifyClient.lambda$createDomainAssociation$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateWebhookResponse createWebhook(CreateWebhookRequest createWebhookRequest) throws BadRequestException, UnauthorizedException, NotFoundException, InternalFailureException, LimitExceededException, DependentServiceFailureException, AwsServiceException, SdkClientException, AmplifyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateWebhookResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createWebhookRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAmplifyClient.resolveMetricPublishers(clientConfiguration, createWebhookRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Amplify");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateWebhook");
            CreateWebhookResponse createWebhookResponse = (CreateWebhookResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateWebhook").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createWebhookRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateWebhookRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createWebhookResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAmplifyClient.lambda$createWebhook$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAppResponse deleteApp(DeleteAppRequest deleteAppRequest) throws BadRequestException, NotFoundException, UnauthorizedException, InternalFailureException, DependentServiceFailureException, AwsServiceException, SdkClientException, AmplifyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAppResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteAppRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAmplifyClient.resolveMetricPublishers(clientConfiguration, deleteAppRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Amplify");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteApp");
            DeleteAppResponse deleteAppResponse = (DeleteAppResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteApp").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteAppRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteAppRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteAppResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAmplifyClient.lambda$deleteApp$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteBackendEnvironmentResponse deleteBackendEnvironment(DeleteBackendEnvironmentRequest deleteBackendEnvironmentRequest) throws BadRequestException, UnauthorizedException, NotFoundException, InternalFailureException, DependentServiceFailureException, AwsServiceException, SdkClientException, AmplifyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteBackendEnvironmentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteBackendEnvironmentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAmplifyClient.resolveMetricPublishers(clientConfiguration, deleteBackendEnvironmentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Amplify");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteBackendEnvironment");
            DeleteBackendEnvironmentResponse deleteBackendEnvironmentResponse = (DeleteBackendEnvironmentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBackendEnvironment").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteBackendEnvironmentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteBackendEnvironmentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteBackendEnvironmentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAmplifyClient.lambda$deleteBackendEnvironment$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteBranchResponse deleteBranch(DeleteBranchRequest deleteBranchRequest) throws BadRequestException, UnauthorizedException, NotFoundException, InternalFailureException, DependentServiceFailureException, AwsServiceException, SdkClientException, AmplifyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteBranchResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteBranchRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAmplifyClient.resolveMetricPublishers(clientConfiguration, deleteBranchRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Amplify");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteBranch");
            DeleteBranchResponse deleteBranchResponse = (DeleteBranchResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBranch").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteBranchRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteBranchRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteBranchResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAmplifyClient.lambda$deleteBranch$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDomainAssociationResponse deleteDomainAssociation(DeleteDomainAssociationRequest deleteDomainAssociationRequest) throws BadRequestException, UnauthorizedException, NotFoundException, InternalFailureException, DependentServiceFailureException, AwsServiceException, SdkClientException, AmplifyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDomainAssociationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteDomainAssociationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAmplifyClient.resolveMetricPublishers(clientConfiguration, deleteDomainAssociationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Amplify");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDomainAssociation");
            DeleteDomainAssociationResponse deleteDomainAssociationResponse = (DeleteDomainAssociationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDomainAssociation").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteDomainAssociationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteDomainAssociationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteDomainAssociationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAmplifyClient.lambda$deleteDomainAssociation$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteJobResponse deleteJob(DeleteJobRequest deleteJobRequest) throws BadRequestException, UnauthorizedException, InternalFailureException, NotFoundException, LimitExceededException, AwsServiceException, SdkClientException, AmplifyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAmplifyClient.resolveMetricPublishers(clientConfiguration, deleteJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Amplify");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteJob");
            DeleteJobResponse deleteJobResponse = (DeleteJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAmplifyClient.lambda$deleteJob$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteWebhookResponse deleteWebhook(DeleteWebhookRequest deleteWebhookRequest) throws BadRequestException, UnauthorizedException, InternalFailureException, NotFoundException, LimitExceededException, AwsServiceException, SdkClientException, AmplifyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteWebhookResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteWebhookRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAmplifyClient.resolveMetricPublishers(clientConfiguration, deleteWebhookRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Amplify");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteWebhook");
            DeleteWebhookResponse deleteWebhookResponse = (DeleteWebhookResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteWebhook").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteWebhookRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteWebhookRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteWebhookResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAmplifyClient.lambda$deleteWebhook$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GenerateAccessLogsResponse generateAccessLogs(GenerateAccessLogsRequest generateAccessLogsRequest) throws NotFoundException, BadRequestException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AmplifyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GenerateAccessLogsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)generateAccessLogsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAmplifyClient.resolveMetricPublishers(clientConfiguration, generateAccessLogsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Amplify");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GenerateAccessLogs");
            GenerateAccessLogsResponse generateAccessLogsResponse = (GenerateAccessLogsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GenerateAccessLogs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)generateAccessLogsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GenerateAccessLogsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return generateAccessLogsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAmplifyClient.lambda$generateAccessLogs$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAppResponse getApp(GetAppRequest getAppRequest) throws BadRequestException, NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AmplifyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAppResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getAppRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAmplifyClient.resolveMetricPublishers(clientConfiguration, getAppRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Amplify");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetApp");
            GetAppResponse getAppResponse = (GetAppResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetApp").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getAppRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetAppRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getAppResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAmplifyClient.lambda$getApp$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetArtifactUrlResponse getArtifactUrl(GetArtifactUrlRequest getArtifactUrlRequest) throws BadRequestException, UnauthorizedException, InternalFailureException, NotFoundException, LimitExceededException, AwsServiceException, SdkClientException, AmplifyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetArtifactUrlResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getArtifactUrlRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAmplifyClient.resolveMetricPublishers(clientConfiguration, getArtifactUrlRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Amplify");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetArtifactUrl");
            GetArtifactUrlResponse getArtifactUrlResponse = (GetArtifactUrlResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetArtifactUrl").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getArtifactUrlRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetArtifactUrlRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getArtifactUrlResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAmplifyClient.lambda$getArtifactUrl$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetBackendEnvironmentResponse getBackendEnvironment(GetBackendEnvironmentRequest getBackendEnvironmentRequest) throws BadRequestException, UnauthorizedException, NotFoundException, InternalFailureException, AwsServiceException, SdkClientException, AmplifyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetBackendEnvironmentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getBackendEnvironmentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAmplifyClient.resolveMetricPublishers(clientConfiguration, getBackendEnvironmentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Amplify");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetBackendEnvironment");
            GetBackendEnvironmentResponse getBackendEnvironmentResponse = (GetBackendEnvironmentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBackendEnvironment").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getBackendEnvironmentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetBackendEnvironmentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getBackendEnvironmentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAmplifyClient.lambda$getBackendEnvironment$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetBranchResponse getBranch(GetBranchRequest getBranchRequest) throws BadRequestException, UnauthorizedException, NotFoundException, InternalFailureException, AwsServiceException, SdkClientException, AmplifyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetBranchResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getBranchRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAmplifyClient.resolveMetricPublishers(clientConfiguration, getBranchRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Amplify");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetBranch");
            GetBranchResponse getBranchResponse = (GetBranchResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBranch").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getBranchRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetBranchRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getBranchResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAmplifyClient.lambda$getBranch$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDomainAssociationResponse getDomainAssociation(GetDomainAssociationRequest getDomainAssociationRequest) throws BadRequestException, UnauthorizedException, NotFoundException, InternalFailureException, AwsServiceException, SdkClientException, AmplifyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDomainAssociationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getDomainAssociationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAmplifyClient.resolveMetricPublishers(clientConfiguration, getDomainAssociationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Amplify");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDomainAssociation");
            GetDomainAssociationResponse getDomainAssociationResponse = (GetDomainAssociationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDomainAssociation").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getDomainAssociationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetDomainAssociationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getDomainAssociationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAmplifyClient.lambda$getDomainAssociation$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetJobResponse getJob(GetJobRequest getJobRequest) throws BadRequestException, UnauthorizedException, InternalFailureException, NotFoundException, LimitExceededException, AwsServiceException, SdkClientException, AmplifyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAmplifyClient.resolveMetricPublishers(clientConfiguration, getJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Amplify");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetJob");
            GetJobResponse getJobResponse = (GetJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAmplifyClient.lambda$getJob$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetWebhookResponse getWebhook(GetWebhookRequest getWebhookRequest) throws BadRequestException, UnauthorizedException, InternalFailureException, NotFoundException, LimitExceededException, AwsServiceException, SdkClientException, AmplifyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetWebhookResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getWebhookRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAmplifyClient.resolveMetricPublishers(clientConfiguration, getWebhookRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Amplify");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetWebhook");
            GetWebhookResponse getWebhookResponse = (GetWebhookResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetWebhook").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getWebhookRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetWebhookRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getWebhookResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAmplifyClient.lambda$getWebhook$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAppsResponse listApps(ListAppsRequest listAppsRequest) throws BadRequestException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AmplifyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAppsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listAppsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAmplifyClient.resolveMetricPublishers(clientConfiguration, listAppsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Amplify");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListApps");
            ListAppsResponse listAppsResponse = (ListAppsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListApps").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listAppsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListAppsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listAppsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAmplifyClient.lambda$listApps$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListArtifactsResponse listArtifacts(ListArtifactsRequest listArtifactsRequest) throws BadRequestException, UnauthorizedException, InternalFailureException, LimitExceededException, AwsServiceException, SdkClientException, AmplifyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListArtifactsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listArtifactsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAmplifyClient.resolveMetricPublishers(clientConfiguration, listArtifactsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Amplify");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListArtifacts");
            ListArtifactsResponse listArtifactsResponse = (ListArtifactsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListArtifacts").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listArtifactsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListArtifactsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listArtifactsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAmplifyClient.lambda$listArtifacts$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListBackendEnvironmentsResponse listBackendEnvironments(ListBackendEnvironmentsRequest listBackendEnvironmentsRequest) throws BadRequestException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AmplifyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListBackendEnvironmentsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listBackendEnvironmentsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAmplifyClient.resolveMetricPublishers(clientConfiguration, listBackendEnvironmentsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Amplify");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListBackendEnvironments");
            ListBackendEnvironmentsResponse listBackendEnvironmentsResponse = (ListBackendEnvironmentsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListBackendEnvironments").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listBackendEnvironmentsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListBackendEnvironmentsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listBackendEnvironmentsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAmplifyClient.lambda$listBackendEnvironments$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListBranchesResponse listBranches(ListBranchesRequest listBranchesRequest) throws BadRequestException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AmplifyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListBranchesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listBranchesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAmplifyClient.resolveMetricPublishers(clientConfiguration, listBranchesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Amplify");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListBranches");
            ListBranchesResponse listBranchesResponse = (ListBranchesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListBranches").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listBranchesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListBranchesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listBranchesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAmplifyClient.lambda$listBranches$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDomainAssociationsResponse listDomainAssociations(ListDomainAssociationsRequest listDomainAssociationsRequest) throws BadRequestException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AmplifyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDomainAssociationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listDomainAssociationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAmplifyClient.resolveMetricPublishers(clientConfiguration, listDomainAssociationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Amplify");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDomainAssociations");
            ListDomainAssociationsResponse listDomainAssociationsResponse = (ListDomainAssociationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDomainAssociations").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listDomainAssociationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListDomainAssociationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listDomainAssociationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAmplifyClient.lambda$listDomainAssociations$24((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListJobsResponse listJobs(ListJobsRequest listJobsRequest) throws BadRequestException, UnauthorizedException, InternalFailureException, LimitExceededException, AwsServiceException, SdkClientException, AmplifyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListJobsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAmplifyClient.resolveMetricPublishers(clientConfiguration, listJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Amplify");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListJobs");
            ListJobsResponse listJobsResponse = (ListJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListJobs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listJobsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listJobsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAmplifyClient.lambda$listJobs$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws InternalFailureException, BadRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, AmplifyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAmplifyClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Amplify");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAmplifyClient.lambda$listTagsForResource$26((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListWebhooksResponse listWebhooks(ListWebhooksRequest listWebhooksRequest) throws BadRequestException, UnauthorizedException, InternalFailureException, LimitExceededException, AwsServiceException, SdkClientException, AmplifyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListWebhooksResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listWebhooksRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAmplifyClient.resolveMetricPublishers(clientConfiguration, listWebhooksRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Amplify");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListWebhooks");
            ListWebhooksResponse listWebhooksResponse = (ListWebhooksResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListWebhooks").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listWebhooksRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListWebhooksRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listWebhooksResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAmplifyClient.lambda$listWebhooks$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartDeploymentResponse startDeployment(StartDeploymentRequest startDeploymentRequest) throws BadRequestException, UnauthorizedException, InternalFailureException, NotFoundException, LimitExceededException, AwsServiceException, SdkClientException, AmplifyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartDeploymentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startDeploymentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAmplifyClient.resolveMetricPublishers(clientConfiguration, startDeploymentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Amplify");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartDeployment");
            StartDeploymentResponse startDeploymentResponse = (StartDeploymentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartDeployment").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startDeploymentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartDeploymentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startDeploymentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAmplifyClient.lambda$startDeployment$28((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartJobResponse startJob(StartJobRequest startJobRequest) throws BadRequestException, UnauthorizedException, InternalFailureException, NotFoundException, LimitExceededException, AwsServiceException, SdkClientException, AmplifyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAmplifyClient.resolveMetricPublishers(clientConfiguration, startJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Amplify");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartJob");
            StartJobResponse startJobResponse = (StartJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAmplifyClient.lambda$startJob$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopJobResponse stopJob(StopJobRequest stopJobRequest) throws BadRequestException, UnauthorizedException, InternalFailureException, NotFoundException, LimitExceededException, AwsServiceException, SdkClientException, AmplifyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAmplifyClient.resolveMetricPublishers(clientConfiguration, stopJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Amplify");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopJob");
            StopJobResponse stopJobResponse = (StopJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)stopJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StopJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAmplifyClient.lambda$stopJob$30((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InternalFailureException, BadRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, AmplifyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAmplifyClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Amplify");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAmplifyClient.lambda$tagResource$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InternalFailureException, BadRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, AmplifyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAmplifyClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Amplify");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAmplifyClient.lambda$untagResource$32((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateAppResponse updateApp(UpdateAppRequest updateAppRequest) throws BadRequestException, NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AmplifyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateAppResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateAppRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAmplifyClient.resolveMetricPublishers(clientConfiguration, updateAppRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Amplify");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateApp");
            UpdateAppResponse updateAppResponse = (UpdateAppResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateApp").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateAppRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateAppRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateAppResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAmplifyClient.lambda$updateApp$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateBranchResponse updateBranch(UpdateBranchRequest updateBranchRequest) throws BadRequestException, UnauthorizedException, NotFoundException, InternalFailureException, DependentServiceFailureException, AwsServiceException, SdkClientException, AmplifyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateBranchResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateBranchRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAmplifyClient.resolveMetricPublishers(clientConfiguration, updateBranchRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Amplify");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateBranch");
            UpdateBranchResponse updateBranchResponse = (UpdateBranchResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateBranch").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateBranchRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateBranchRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateBranchResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAmplifyClient.lambda$updateBranch$34((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateDomainAssociationResponse updateDomainAssociation(UpdateDomainAssociationRequest updateDomainAssociationRequest) throws BadRequestException, UnauthorizedException, NotFoundException, InternalFailureException, DependentServiceFailureException, AwsServiceException, SdkClientException, AmplifyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDomainAssociationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateDomainAssociationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAmplifyClient.resolveMetricPublishers(clientConfiguration, updateDomainAssociationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Amplify");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateDomainAssociation");
            UpdateDomainAssociationResponse updateDomainAssociationResponse = (UpdateDomainAssociationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDomainAssociation").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateDomainAssociationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateDomainAssociationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateDomainAssociationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAmplifyClient.lambda$updateDomainAssociation$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateWebhookResponse updateWebhook(UpdateWebhookRequest updateWebhookRequest) throws BadRequestException, UnauthorizedException, NotFoundException, InternalFailureException, DependentServiceFailureException, AwsServiceException, SdkClientException, AmplifyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateWebhookResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateWebhookRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAmplifyClient.resolveMetricPublishers(clientConfiguration, updateWebhookRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Amplify");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateWebhook");
            UpdateWebhookResponse updateWebhookResponse = (UpdateWebhookResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateWebhook").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateWebhookRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateWebhookRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateWebhookResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAmplifyClient.lambda$updateWebhook$36((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "amplify";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        AmplifyServiceClientConfigurationBuilder.BuilderInternal serviceConfigBuilder = AmplifyServiceClientConfigurationBuilder.builder(clientConfiguration.toBuilder());
        serviceConfigBuilder.overrideConfiguration(this.serviceClientConfiguration.overrideConfiguration());
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        return serviceConfigBuilder.buildSdkClientConfiguration();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(AmplifyException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("InternalFailureException").exceptionBuilderSupplier(InternalFailureException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NotFoundException").exceptionBuilderSupplier(NotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnauthorizedException").exceptionBuilderSupplier(UnauthorizedException::builder).httpStatusCode(Integer.valueOf(401)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LimitExceededException").exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(Integer.valueOf(429)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DependentServiceFailureException").exceptionBuilderSupplier(DependentServiceFailureException::builder).httpStatusCode(Integer.valueOf(503)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BadRequestException").exceptionBuilderSupplier(BadRequestException::builder).httpStatusCode(Integer.valueOf(400)).build());
    }

    @Override
    public final AmplifyServiceClientConfiguration serviceClientConfiguration() {
        return this.serviceClientConfiguration;
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateWebhook$36(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateDomainAssociation$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateBranch$34(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateApp$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$32(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopJob$30(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startJob$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startDeployment$28(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listWebhooks$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listJobs$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDomainAssociations$24(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listBranches$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listBackendEnvironments$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listArtifacts$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listApps$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getWebhook$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getJob$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDomainAssociation$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getBranch$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getBackendEnvironment$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getArtifactUrl$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getApp$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$generateAccessLogs$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteWebhook$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteJob$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDomainAssociation$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteBranch$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteBackendEnvironment$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteApp$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createWebhook$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDomainAssociation$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDeployment$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createBranch$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createBackendEnvironment$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createApp$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

