/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplify.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an execution step, for an execution job, for an Amplify app.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Step implements SdkPojo, Serializable, ToCopyableBuilder<Step.Builder, Step> {
    private static final SdkField<String> STEP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stepName").getter(getter(Step::stepName)).setter(setter(Builder::stepName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepName").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime").getter(getter(Step::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(Step::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime").getter(getter(Step::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()).build();

    private static final SdkField<String> LOG_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("logUrl")
            .getter(getter(Step::logUrl)).setter(setter(Builder::logUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logUrl").build()).build();

    private static final SdkField<String> ARTIFACTS_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("artifactsUrl").getter(getter(Step::artifactsUrl)).setter(setter(Builder::artifactsUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("artifactsUrl").build()).build();

    private static final SdkField<String> TEST_ARTIFACTS_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testArtifactsUrl").getter(getter(Step::testArtifactsUrl)).setter(setter(Builder::testArtifactsUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testArtifactsUrl").build()).build();

    private static final SdkField<String> TEST_CONFIG_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testConfigUrl").getter(getter(Step::testConfigUrl)).setter(setter(Builder::testConfigUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testConfigUrl").build()).build();

    private static final SdkField<Map<String, String>> SCREENSHOTS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("screenshots")
            .getter(getter(Step::screenshots))
            .setter(setter(Builder::screenshots))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("screenshots").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusReason").getter(getter(Step::statusReason)).setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()).build();

    private static final SdkField<String> CONTEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("context")
            .getter(getter(Step::context)).setter(setter(Builder::context))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("context").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STEP_NAME_FIELD,
            START_TIME_FIELD, STATUS_FIELD, END_TIME_FIELD, LOG_URL_FIELD, ARTIFACTS_URL_FIELD, TEST_ARTIFACTS_URL_FIELD,
            TEST_CONFIG_URL_FIELD, SCREENSHOTS_FIELD, STATUS_REASON_FIELD, CONTEXT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String stepName;

    private final Instant startTime;

    private final String status;

    private final Instant endTime;

    private final String logUrl;

    private final String artifactsUrl;

    private final String testArtifactsUrl;

    private final String testConfigUrl;

    private final Map<String, String> screenshots;

    private final String statusReason;

    private final String context;

    private Step(BuilderImpl builder) {
        this.stepName = builder.stepName;
        this.startTime = builder.startTime;
        this.status = builder.status;
        this.endTime = builder.endTime;
        this.logUrl = builder.logUrl;
        this.artifactsUrl = builder.artifactsUrl;
        this.testArtifactsUrl = builder.testArtifactsUrl;
        this.testConfigUrl = builder.testConfigUrl;
        this.screenshots = builder.screenshots;
        this.statusReason = builder.statusReason;
        this.context = builder.context;
    }

    /**
     * <p>
     * The name of the execution step.
     * </p>
     * 
     * @return The name of the execution step.
     */
    public final String stepName() {
        return stepName;
    }

    /**
     * <p>
     * The start date and time of the execution step.
     * </p>
     * 
     * @return The start date and time of the execution step.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The status of the execution step.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the execution step.
     * @see JobStatus
     */
    public final JobStatus status() {
        return JobStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the execution step.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the execution step.
     * @see JobStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The end date and time of the execution step.
     * </p>
     * 
     * @return The end date and time of the execution step.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The URL to the logs for the execution step.
     * </p>
     * 
     * @return The URL to the logs for the execution step.
     */
    public final String logUrl() {
        return logUrl;
    }

    /**
     * <p>
     * The URL to the artifact for the execution step.
     * </p>
     * 
     * @return The URL to the artifact for the execution step.
     */
    public final String artifactsUrl() {
        return artifactsUrl;
    }

    /**
     * <p>
     * The URL to the test artifact for the execution step.
     * </p>
     * 
     * @return The URL to the test artifact for the execution step.
     */
    public final String testArtifactsUrl() {
        return testArtifactsUrl;
    }

    /**
     * <p>
     * The URL to the test configuration for the execution step.
     * </p>
     * 
     * @return The URL to the test configuration for the execution step.
     */
    public final String testConfigUrl() {
        return testConfigUrl;
    }

    /**
     * Returns true if the Screenshots property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasScreenshots() {
        return screenshots != null && !(screenshots instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The list of screenshot URLs for the execution step, if relevant.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasScreenshots()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of screenshot URLs for the execution step, if relevant.
     */
    public final Map<String, String> screenshots() {
        return screenshots;
    }

    /**
     * <p>
     * The reason for the current step status.
     * </p>
     * 
     * @return The reason for the current step status.
     */
    public final String statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * The context for the current step. Includes a build image if the step is build.
     * </p>
     * 
     * @return The context for the current step. Includes a build image if the step is build.
     */
    public final String context() {
        return context;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stepName());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(logUrl());
        hashCode = 31 * hashCode + Objects.hashCode(artifactsUrl());
        hashCode = 31 * hashCode + Objects.hashCode(testArtifactsUrl());
        hashCode = 31 * hashCode + Objects.hashCode(testConfigUrl());
        hashCode = 31 * hashCode + Objects.hashCode(hasScreenshots() ? screenshots() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(context());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Step)) {
            return false;
        }
        Step other = (Step) obj;
        return Objects.equals(stepName(), other.stepName()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(logUrl(), other.logUrl()) && Objects.equals(artifactsUrl(), other.artifactsUrl())
                && Objects.equals(testArtifactsUrl(), other.testArtifactsUrl())
                && Objects.equals(testConfigUrl(), other.testConfigUrl()) && hasScreenshots() == other.hasScreenshots()
                && Objects.equals(screenshots(), other.screenshots()) && Objects.equals(statusReason(), other.statusReason())
                && Objects.equals(context(), other.context());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Step").add("StepName", stepName()).add("StartTime", startTime()).add("Status", statusAsString())
                .add("EndTime", endTime()).add("LogUrl", logUrl()).add("ArtifactsUrl", artifactsUrl())
                .add("TestArtifactsUrl", testArtifactsUrl()).add("TestConfigUrl", testConfigUrl())
                .add("Screenshots", hasScreenshots() ? screenshots() : null).add("StatusReason", statusReason())
                .add("Context", context()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "stepName":
            return Optional.ofNullable(clazz.cast(stepName()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "logUrl":
            return Optional.ofNullable(clazz.cast(logUrl()));
        case "artifactsUrl":
            return Optional.ofNullable(clazz.cast(artifactsUrl()));
        case "testArtifactsUrl":
            return Optional.ofNullable(clazz.cast(testArtifactsUrl()));
        case "testConfigUrl":
            return Optional.ofNullable(clazz.cast(testConfigUrl()));
        case "screenshots":
            return Optional.ofNullable(clazz.cast(screenshots()));
        case "statusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "context":
            return Optional.ofNullable(clazz.cast(context()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Step, T> g) {
        return obj -> g.apply((Step) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Step> {
        /**
         * <p>
         * The name of the execution step.
         * </p>
         * 
         * @param stepName
         *        The name of the execution step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepName(String stepName);

        /**
         * <p>
         * The start date and time of the execution step.
         * </p>
         * 
         * @param startTime
         *        The start date and time of the execution step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The status of the execution step.
         * </p>
         * 
         * @param status
         *        The status of the execution step.
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the execution step.
         * </p>
         * 
         * @param status
         *        The status of the execution step.
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder status(JobStatus status);

        /**
         * <p>
         * The end date and time of the execution step.
         * </p>
         * 
         * @param endTime
         *        The end date and time of the execution step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The URL to the logs for the execution step.
         * </p>
         * 
         * @param logUrl
         *        The URL to the logs for the execution step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logUrl(String logUrl);

        /**
         * <p>
         * The URL to the artifact for the execution step.
         * </p>
         * 
         * @param artifactsUrl
         *        The URL to the artifact for the execution step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder artifactsUrl(String artifactsUrl);

        /**
         * <p>
         * The URL to the test artifact for the execution step.
         * </p>
         * 
         * @param testArtifactsUrl
         *        The URL to the test artifact for the execution step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testArtifactsUrl(String testArtifactsUrl);

        /**
         * <p>
         * The URL to the test configuration for the execution step.
         * </p>
         * 
         * @param testConfigUrl
         *        The URL to the test configuration for the execution step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testConfigUrl(String testConfigUrl);

        /**
         * <p>
         * The list of screenshot URLs for the execution step, if relevant.
         * </p>
         * 
         * @param screenshots
         *        The list of screenshot URLs for the execution step, if relevant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder screenshots(Map<String, String> screenshots);

        /**
         * <p>
         * The reason for the current step status.
         * </p>
         * 
         * @param statusReason
         *        The reason for the current step status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * The context for the current step. Includes a build image if the step is build.
         * </p>
         * 
         * @param context
         *        The context for the current step. Includes a build image if the step is build.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder context(String context);
    }

    static final class BuilderImpl implements Builder {
        private String stepName;

        private Instant startTime;

        private String status;

        private Instant endTime;

        private String logUrl;

        private String artifactsUrl;

        private String testArtifactsUrl;

        private String testConfigUrl;

        private Map<String, String> screenshots = DefaultSdkAutoConstructMap.getInstance();

        private String statusReason;

        private String context;

        private BuilderImpl() {
        }

        private BuilderImpl(Step model) {
            stepName(model.stepName);
            startTime(model.startTime);
            status(model.status);
            endTime(model.endTime);
            logUrl(model.logUrl);
            artifactsUrl(model.artifactsUrl);
            testArtifactsUrl(model.testArtifactsUrl);
            testConfigUrl(model.testConfigUrl);
            screenshots(model.screenshots);
            statusReason(model.statusReason);
            context(model.context);
        }

        public final String getStepName() {
            return stepName;
        }

        @Override
        public final Builder stepName(String stepName) {
            this.stepName = stepName;
            return this;
        }

        public final void setStepName(String stepName) {
            this.stepName = stepName;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(JobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final String getLogUrl() {
            return logUrl;
        }

        @Override
        public final Builder logUrl(String logUrl) {
            this.logUrl = logUrl;
            return this;
        }

        public final void setLogUrl(String logUrl) {
            this.logUrl = logUrl;
        }

        public final String getArtifactsUrl() {
            return artifactsUrl;
        }

        @Override
        public final Builder artifactsUrl(String artifactsUrl) {
            this.artifactsUrl = artifactsUrl;
            return this;
        }

        public final void setArtifactsUrl(String artifactsUrl) {
            this.artifactsUrl = artifactsUrl;
        }

        public final String getTestArtifactsUrl() {
            return testArtifactsUrl;
        }

        @Override
        public final Builder testArtifactsUrl(String testArtifactsUrl) {
            this.testArtifactsUrl = testArtifactsUrl;
            return this;
        }

        public final void setTestArtifactsUrl(String testArtifactsUrl) {
            this.testArtifactsUrl = testArtifactsUrl;
        }

        public final String getTestConfigUrl() {
            return testConfigUrl;
        }

        @Override
        public final Builder testConfigUrl(String testConfigUrl) {
            this.testConfigUrl = testConfigUrl;
            return this;
        }

        public final void setTestConfigUrl(String testConfigUrl) {
            this.testConfigUrl = testConfigUrl;
        }

        public final Map<String, String> getScreenshots() {
            if (screenshots instanceof SdkAutoConstructMap) {
                return null;
            }
            return screenshots;
        }

        @Override
        public final Builder screenshots(Map<String, String> screenshots) {
            this.screenshots = ScreenshotsCopier.copy(screenshots);
            return this;
        }

        public final void setScreenshots(Map<String, String> screenshots) {
            this.screenshots = ScreenshotsCopier.copy(screenshots);
        }

        public final String getStatusReason() {
            return statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        public final String getContext() {
            return context;
        }

        @Override
        public final Builder context(String context) {
            this.context = context;
            return this;
        }

        public final void setContext(String context) {
            this.context = context;
        }

        @Override
        public Step build() {
            return new Step(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
