/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplify.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.amplify.model.AmplifyResponse;
import software.amazon.awssdk.services.amplify.model.JobSummariesCopier;
import software.amazon.awssdk.services.amplify.model.JobSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListJobsResponse
extends AmplifyResponse
implements ToCopyableBuilder<Builder, ListJobsResponse> {
    private static final SdkField<List<JobSummary>> JOB_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("jobSummaries").getter(ListJobsResponse.getter(ListJobsResponse::jobSummaries)).setter(ListJobsResponse.setter(Builder::jobSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(JobSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListJobsResponse.getter(ListJobsResponse::nextToken)).setter(ListJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<JobSummary> jobSummaries;
    private final String nextToken;

    private ListJobsResponse(BuilderImpl builder) {
        super(builder);
        this.jobSummaries = builder.jobSummaries;
        this.nextToken = builder.nextToken;
    }

    public boolean hasJobSummaries() {
        return this.jobSummaries != null && !(this.jobSummaries instanceof SdkAutoConstructList);
    }

    public List<JobSummary> jobSummaries() {
        return this.jobSummaries;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasJobSummaries() ? this.jobSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListJobsResponse)) {
            return false;
        }
        ListJobsResponse other = (ListJobsResponse)((Object)obj);
        return this.hasJobSummaries() == other.hasJobSummaries() && Objects.equals(this.jobSummaries(), other.jobSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListJobsResponse").add("JobSummaries", this.hasJobSummaries() ? this.jobSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobSummaries": {
                return Optional.ofNullable(clazz.cast(this.jobSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListJobsResponse, T> g) {
        return obj -> g.apply((ListJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AmplifyResponse.BuilderImpl
    implements Builder {
        private List<JobSummary> jobSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListJobsResponse model) {
            super(model);
            this.jobSummaries(model.jobSummaries);
            this.nextToken(model.nextToken);
        }

        public final Collection<JobSummary.Builder> getJobSummaries() {
            if (this.jobSummaries instanceof SdkAutoConstructList) {
                return null;
            }
            return this.jobSummaries != null ? (Collection)this.jobSummaries.stream().map(JobSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder jobSummaries(Collection<JobSummary> jobSummaries) {
            this.jobSummaries = JobSummariesCopier.copy(jobSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobSummaries(JobSummary ... jobSummaries) {
            this.jobSummaries(Arrays.asList(jobSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobSummaries(Consumer<JobSummary.Builder> ... jobSummaries) {
            this.jobSummaries(Stream.of(jobSummaries).map(c -> (JobSummary)((JobSummary.Builder)JobSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setJobSummaries(Collection<JobSummary.BuilderImpl> jobSummaries) {
            this.jobSummaries = JobSummariesCopier.copyFromBuilder(jobSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListJobsResponse build() {
            return new ListJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AmplifyResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListJobsResponse> {
        public Builder jobSummaries(Collection<JobSummary> var1);

        public Builder jobSummaries(JobSummary ... var1);

        public Builder jobSummaries(Consumer<JobSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

