/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amp.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This structure contains the description of the workspace configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorkspaceConfigurationDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<WorkspaceConfigurationDescription.Builder, WorkspaceConfigurationDescription> {
    private static final SdkField<WorkspaceConfigurationStatus> STATUS_FIELD = SdkField
            .<WorkspaceConfigurationStatus> builder(MarshallingType.SDK_POJO).memberName("status")
            .getter(getter(WorkspaceConfigurationDescription::status)).setter(setter(Builder::status))
            .constructor(WorkspaceConfigurationStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<List<LimitsPerLabelSet>> LIMITS_PER_LABEL_SET_FIELD = SdkField
            .<List<LimitsPerLabelSet>> builder(MarshallingType.LIST)
            .memberName("limitsPerLabelSet")
            .getter(getter(WorkspaceConfigurationDescription::limitsPerLabelSet))
            .setter(setter(Builder::limitsPerLabelSet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("limitsPerLabelSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LimitsPerLabelSet> builder(MarshallingType.SDK_POJO)
                                            .constructor(LimitsPerLabelSet::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> RETENTION_PERIOD_IN_DAYS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("retentionPeriodInDays").getter(getter(WorkspaceConfigurationDescription::retentionPeriodInDays))
            .setter(setter(Builder::retentionPeriodInDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retentionPeriodInDays").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            LIMITS_PER_LABEL_SET_FIELD, RETENTION_PERIOD_IN_DAYS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final WorkspaceConfigurationStatus status;

    private final List<LimitsPerLabelSet> limitsPerLabelSet;

    private final Integer retentionPeriodInDays;

    private WorkspaceConfigurationDescription(BuilderImpl builder) {
        this.status = builder.status;
        this.limitsPerLabelSet = builder.limitsPerLabelSet;
        this.retentionPeriodInDays = builder.retentionPeriodInDays;
    }

    /**
     * <p>
     * This structure displays the current status of the workspace configuration, and might also contain a reason for
     * that status.
     * </p>
     * 
     * @return This structure displays the current status of the workspace configuration, and might also contain a
     *         reason for that status.
     */
    public final WorkspaceConfigurationStatus status() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the LimitsPerLabelSet property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLimitsPerLabelSet() {
        return limitsPerLabelSet != null && !(limitsPerLabelSet instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * This is an array of structures, where each structure displays one label sets for the workspace and the limits for
     * that label set.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLimitsPerLabelSet} method.
     * </p>
     * 
     * @return This is an array of structures, where each structure displays one label sets for the workspace and the
     *         limits for that label set.
     */
    public final List<LimitsPerLabelSet> limitsPerLabelSet() {
        return limitsPerLabelSet;
    }

    /**
     * <p>
     * This field displays how many days that metrics are retained in the workspace.
     * </p>
     * 
     * @return This field displays how many days that metrics are retained in the workspace.
     */
    public final Integer retentionPeriodInDays() {
        return retentionPeriodInDays;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(hasLimitsPerLabelSet() ? limitsPerLabelSet() : null);
        hashCode = 31 * hashCode + Objects.hashCode(retentionPeriodInDays());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkspaceConfigurationDescription)) {
            return false;
        }
        WorkspaceConfigurationDescription other = (WorkspaceConfigurationDescription) obj;
        return Objects.equals(status(), other.status()) && hasLimitsPerLabelSet() == other.hasLimitsPerLabelSet()
                && Objects.equals(limitsPerLabelSet(), other.limitsPerLabelSet())
                && Objects.equals(retentionPeriodInDays(), other.retentionPeriodInDays());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WorkspaceConfigurationDescription").add("Status", status())
                .add("LimitsPerLabelSet", hasLimitsPerLabelSet() ? limitsPerLabelSet() : null)
                .add("RetentionPeriodInDays", retentionPeriodInDays()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "limitsPerLabelSet":
            return Optional.ofNullable(clazz.cast(limitsPerLabelSet()));
        case "retentionPeriodInDays":
            return Optional.ofNullable(clazz.cast(retentionPeriodInDays()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("status", STATUS_FIELD);
        map.put("limitsPerLabelSet", LIMITS_PER_LABEL_SET_FIELD);
        map.put("retentionPeriodInDays", RETENTION_PERIOD_IN_DAYS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WorkspaceConfigurationDescription, T> g) {
        return obj -> g.apply((WorkspaceConfigurationDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorkspaceConfigurationDescription> {
        /**
         * <p>
         * This structure displays the current status of the workspace configuration, and might also contain a reason
         * for that status.
         * </p>
         * 
         * @param status
         *        This structure displays the current status of the workspace configuration, and might also contain a
         *        reason for that status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(WorkspaceConfigurationStatus status);

        /**
         * <p>
         * This structure displays the current status of the workspace configuration, and might also contain a reason
         * for that status.
         * </p>
         * This is a convenience method that creates an instance of the {@link WorkspaceConfigurationStatus.Builder}
         * avoiding the need to create one manually via {@link WorkspaceConfigurationStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WorkspaceConfigurationStatus.Builder#build()} is called
         * immediately and its result is passed to {@link #status(WorkspaceConfigurationStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link WorkspaceConfigurationStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(WorkspaceConfigurationStatus)
         */
        default Builder status(Consumer<WorkspaceConfigurationStatus.Builder> status) {
            return status(WorkspaceConfigurationStatus.builder().applyMutation(status).build());
        }

        /**
         * <p>
         * This is an array of structures, where each structure displays one label sets for the workspace and the limits
         * for that label set.
         * </p>
         * 
         * @param limitsPerLabelSet
         *        This is an array of structures, where each structure displays one label sets for the workspace and the
         *        limits for that label set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limitsPerLabelSet(Collection<LimitsPerLabelSet> limitsPerLabelSet);

        /**
         * <p>
         * This is an array of structures, where each structure displays one label sets for the workspace and the limits
         * for that label set.
         * </p>
         * 
         * @param limitsPerLabelSet
         *        This is an array of structures, where each structure displays one label sets for the workspace and the
         *        limits for that label set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limitsPerLabelSet(LimitsPerLabelSet... limitsPerLabelSet);

        /**
         * <p>
         * This is an array of structures, where each structure displays one label sets for the workspace and the limits
         * for that label set.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.amp.model.LimitsPerLabelSet.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.amp.model.LimitsPerLabelSet#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.amp.model.LimitsPerLabelSet.Builder#build()} is called immediately and
         * its result is passed to {@link #limitsPerLabelSet(List<LimitsPerLabelSet>)}.
         * 
         * @param limitsPerLabelSet
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.amp.model.LimitsPerLabelSet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #limitsPerLabelSet(java.util.Collection<LimitsPerLabelSet>)
         */
        Builder limitsPerLabelSet(Consumer<LimitsPerLabelSet.Builder>... limitsPerLabelSet);

        /**
         * <p>
         * This field displays how many days that metrics are retained in the workspace.
         * </p>
         * 
         * @param retentionPeriodInDays
         *        This field displays how many days that metrics are retained in the workspace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retentionPeriodInDays(Integer retentionPeriodInDays);
    }

    static final class BuilderImpl implements Builder {
        private WorkspaceConfigurationStatus status;

        private List<LimitsPerLabelSet> limitsPerLabelSet = DefaultSdkAutoConstructList.getInstance();

        private Integer retentionPeriodInDays;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkspaceConfigurationDescription model) {
            status(model.status);
            limitsPerLabelSet(model.limitsPerLabelSet);
            retentionPeriodInDays(model.retentionPeriodInDays);
        }

        public final WorkspaceConfigurationStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        public final void setStatus(WorkspaceConfigurationStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(WorkspaceConfigurationStatus status) {
            this.status = status;
            return this;
        }

        public final List<LimitsPerLabelSet.Builder> getLimitsPerLabelSet() {
            List<LimitsPerLabelSet.Builder> result = LimitsPerLabelSetListCopier.copyToBuilder(this.limitsPerLabelSet);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLimitsPerLabelSet(Collection<LimitsPerLabelSet.BuilderImpl> limitsPerLabelSet) {
            this.limitsPerLabelSet = LimitsPerLabelSetListCopier.copyFromBuilder(limitsPerLabelSet);
        }

        @Override
        public final Builder limitsPerLabelSet(Collection<LimitsPerLabelSet> limitsPerLabelSet) {
            this.limitsPerLabelSet = LimitsPerLabelSetListCopier.copy(limitsPerLabelSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder limitsPerLabelSet(LimitsPerLabelSet... limitsPerLabelSet) {
            limitsPerLabelSet(Arrays.asList(limitsPerLabelSet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder limitsPerLabelSet(Consumer<LimitsPerLabelSet.Builder>... limitsPerLabelSet) {
            limitsPerLabelSet(Stream.of(limitsPerLabelSet).map(c -> LimitsPerLabelSet.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Integer getRetentionPeriodInDays() {
            return retentionPeriodInDays;
        }

        public final void setRetentionPeriodInDays(Integer retentionPeriodInDays) {
            this.retentionPeriodInDays = retentionPeriodInDays;
        }

        @Override
        public final Builder retentionPeriodInDays(Integer retentionPeriodInDays) {
            this.retentionPeriodInDays = retentionPeriodInDays;
            return this;
        }

        @Override
        public WorkspaceConfigurationDescription build() {
            return new WorkspaceConfigurationDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
