/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amp.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration for the Random Cut Forest algorithm used for anomaly detection in time-series data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RandomCutForestConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<RandomCutForestConfiguration.Builder, RandomCutForestConfiguration> {
    private static final SdkField<String> QUERY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("query")
            .getter(getter(RandomCutForestConfiguration::query)).setter(setter(Builder::query))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("query").build()).build();

    private static final SdkField<Integer> SHINGLE_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("shingleSize").getter(getter(RandomCutForestConfiguration::shingleSize))
            .setter(setter(Builder::shingleSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shingleSize").build()).build();

    private static final SdkField<Integer> SAMPLE_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("sampleSize").getter(getter(RandomCutForestConfiguration::sampleSize))
            .setter(setter(Builder::sampleSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleSize").build()).build();

    private static final SdkField<IgnoreNearExpected> IGNORE_NEAR_EXPECTED_FROM_ABOVE_FIELD = SdkField
            .<IgnoreNearExpected> builder(MarshallingType.SDK_POJO)
            .memberName("ignoreNearExpectedFromAbove")
            .getter(getter(RandomCutForestConfiguration::ignoreNearExpectedFromAbove))
            .setter(setter(Builder::ignoreNearExpectedFromAbove))
            .constructor(IgnoreNearExpected::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ignoreNearExpectedFromAbove")
                    .build()).build();

    private static final SdkField<IgnoreNearExpected> IGNORE_NEAR_EXPECTED_FROM_BELOW_FIELD = SdkField
            .<IgnoreNearExpected> builder(MarshallingType.SDK_POJO)
            .memberName("ignoreNearExpectedFromBelow")
            .getter(getter(RandomCutForestConfiguration::ignoreNearExpectedFromBelow))
            .setter(setter(Builder::ignoreNearExpectedFromBelow))
            .constructor(IgnoreNearExpected::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ignoreNearExpectedFromBelow")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_FIELD,
            SHINGLE_SIZE_FIELD, SAMPLE_SIZE_FIELD, IGNORE_NEAR_EXPECTED_FROM_ABOVE_FIELD, IGNORE_NEAR_EXPECTED_FROM_BELOW_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String query;

    private final Integer shingleSize;

    private final Integer sampleSize;

    private final IgnoreNearExpected ignoreNearExpectedFromAbove;

    private final IgnoreNearExpected ignoreNearExpectedFromBelow;

    private RandomCutForestConfiguration(BuilderImpl builder) {
        this.query = builder.query;
        this.shingleSize = builder.shingleSize;
        this.sampleSize = builder.sampleSize;
        this.ignoreNearExpectedFromAbove = builder.ignoreNearExpectedFromAbove;
        this.ignoreNearExpectedFromBelow = builder.ignoreNearExpectedFromBelow;
    }

    /**
     * <p>
     * The Prometheus query used to retrieve the time-series data for anomaly detection.
     * </p>
     * <important>
     * <p>
     * Random Cut Forest queries must be wrapped by a supported PromQL aggregation operator. For more information, see
     * <a href="https://prometheus.io/docs/prometheus/latest/querying/operators/#aggregation-operators">Aggregation
     * operators</a> on the <i>Prometheus docs</i> website.
     * </p>
     * <p>
     * <b>Supported PromQL aggregation operators</b>: <code>avg</code>, <code>count</code>, <code>group</code>,
     * <code>max</code>, <code>min</code>, <code>quantile</code>, <code>stddev</code>, <code>stdvar</code>, and
     * <code>sum</code>.
     * </p>
     * </important>
     * 
     * @return The Prometheus query used to retrieve the time-series data for anomaly detection.</p> <important>
     *         <p>
     *         Random Cut Forest queries must be wrapped by a supported PromQL aggregation operator. For more
     *         information, see <a
     *         href="https://prometheus.io/docs/prometheus/latest/querying/operators/#aggregation-operators">Aggregation
     *         operators</a> on the <i>Prometheus docs</i> website.
     *         </p>
     *         <p>
     *         <b>Supported PromQL aggregation operators</b>: <code>avg</code>, <code>count</code>, <code>group</code>,
     *         <code>max</code>, <code>min</code>, <code>quantile</code>, <code>stddev</code>, <code>stdvar</code>, and
     *         <code>sum</code>.
     *         </p>
     */
    public final String query() {
        return query;
    }

    /**
     * <p>
     * The number of consecutive data points used to create a shingle for the Random Cut Forest algorithm. The default
     * number is 8 consecutive data points.
     * </p>
     * 
     * @return The number of consecutive data points used to create a shingle for the Random Cut Forest algorithm. The
     *         default number is 8 consecutive data points.
     */
    public final Integer shingleSize() {
        return shingleSize;
    }

    /**
     * <p>
     * The number of data points sampled from the input stream for the Random Cut Forest algorithm. The default number
     * is 256 consecutive data points.
     * </p>
     * 
     * @return The number of data points sampled from the input stream for the Random Cut Forest algorithm. The default
     *         number is 256 consecutive data points.
     */
    public final Integer sampleSize() {
        return sampleSize;
    }

    /**
     * <p>
     * Configuration for ignoring values that are near expected values from above during anomaly detection.
     * </p>
     * 
     * @return Configuration for ignoring values that are near expected values from above during anomaly detection.
     */
    public final IgnoreNearExpected ignoreNearExpectedFromAbove() {
        return ignoreNearExpectedFromAbove;
    }

    /**
     * <p>
     * Configuration for ignoring values that are near expected values from below during anomaly detection.
     * </p>
     * 
     * @return Configuration for ignoring values that are near expected values from below during anomaly detection.
     */
    public final IgnoreNearExpected ignoreNearExpectedFromBelow() {
        return ignoreNearExpectedFromBelow;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(query());
        hashCode = 31 * hashCode + Objects.hashCode(shingleSize());
        hashCode = 31 * hashCode + Objects.hashCode(sampleSize());
        hashCode = 31 * hashCode + Objects.hashCode(ignoreNearExpectedFromAbove());
        hashCode = 31 * hashCode + Objects.hashCode(ignoreNearExpectedFromBelow());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RandomCutForestConfiguration)) {
            return false;
        }
        RandomCutForestConfiguration other = (RandomCutForestConfiguration) obj;
        return Objects.equals(query(), other.query()) && Objects.equals(shingleSize(), other.shingleSize())
                && Objects.equals(sampleSize(), other.sampleSize())
                && Objects.equals(ignoreNearExpectedFromAbove(), other.ignoreNearExpectedFromAbove())
                && Objects.equals(ignoreNearExpectedFromBelow(), other.ignoreNearExpectedFromBelow());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RandomCutForestConfiguration").add("Query", query()).add("ShingleSize", shingleSize())
                .add("SampleSize", sampleSize()).add("IgnoreNearExpectedFromAbove", ignoreNearExpectedFromAbove())
                .add("IgnoreNearExpectedFromBelow", ignoreNearExpectedFromBelow()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "query":
            return Optional.ofNullable(clazz.cast(query()));
        case "shingleSize":
            return Optional.ofNullable(clazz.cast(shingleSize()));
        case "sampleSize":
            return Optional.ofNullable(clazz.cast(sampleSize()));
        case "ignoreNearExpectedFromAbove":
            return Optional.ofNullable(clazz.cast(ignoreNearExpectedFromAbove()));
        case "ignoreNearExpectedFromBelow":
            return Optional.ofNullable(clazz.cast(ignoreNearExpectedFromBelow()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("query", QUERY_FIELD);
        map.put("shingleSize", SHINGLE_SIZE_FIELD);
        map.put("sampleSize", SAMPLE_SIZE_FIELD);
        map.put("ignoreNearExpectedFromAbove", IGNORE_NEAR_EXPECTED_FROM_ABOVE_FIELD);
        map.put("ignoreNearExpectedFromBelow", IGNORE_NEAR_EXPECTED_FROM_BELOW_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RandomCutForestConfiguration, T> g) {
        return obj -> g.apply((RandomCutForestConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RandomCutForestConfiguration> {
        /**
         * <p>
         * The Prometheus query used to retrieve the time-series data for anomaly detection.
         * </p>
         * <important>
         * <p>
         * Random Cut Forest queries must be wrapped by a supported PromQL aggregation operator. For more information,
         * see <a
         * href="https://prometheus.io/docs/prometheus/latest/querying/operators/#aggregation-operators">Aggregation
         * operators</a> on the <i>Prometheus docs</i> website.
         * </p>
         * <p>
         * <b>Supported PromQL aggregation operators</b>: <code>avg</code>, <code>count</code>, <code>group</code>,
         * <code>max</code>, <code>min</code>, <code>quantile</code>, <code>stddev</code>, <code>stdvar</code>, and
         * <code>sum</code>.
         * </p>
         * </important>
         * 
         * @param query
         *        The Prometheus query used to retrieve the time-series data for anomaly detection.</p> <important>
         *        <p>
         *        Random Cut Forest queries must be wrapped by a supported PromQL aggregation operator. For more
         *        information, see <a
         *        href="https://prometheus.io/docs/prometheus/latest/querying/operators/#aggregation-operators"
         *        >Aggregation operators</a> on the <i>Prometheus docs</i> website.
         *        </p>
         *        <p>
         *        <b>Supported PromQL aggregation operators</b>: <code>avg</code>, <code>count</code>,
         *        <code>group</code>, <code>max</code>, <code>min</code>, <code>quantile</code>, <code>stddev</code>,
         *        <code>stdvar</code>, and <code>sum</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder query(String query);

        /**
         * <p>
         * The number of consecutive data points used to create a shingle for the Random Cut Forest algorithm. The
         * default number is 8 consecutive data points.
         * </p>
         * 
         * @param shingleSize
         *        The number of consecutive data points used to create a shingle for the Random Cut Forest algorithm.
         *        The default number is 8 consecutive data points.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shingleSize(Integer shingleSize);

        /**
         * <p>
         * The number of data points sampled from the input stream for the Random Cut Forest algorithm. The default
         * number is 256 consecutive data points.
         * </p>
         * 
         * @param sampleSize
         *        The number of data points sampled from the input stream for the Random Cut Forest algorithm. The
         *        default number is 256 consecutive data points.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampleSize(Integer sampleSize);

        /**
         * <p>
         * Configuration for ignoring values that are near expected values from above during anomaly detection.
         * </p>
         * 
         * @param ignoreNearExpectedFromAbove
         *        Configuration for ignoring values that are near expected values from above during anomaly detection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ignoreNearExpectedFromAbove(IgnoreNearExpected ignoreNearExpectedFromAbove);

        /**
         * <p>
         * Configuration for ignoring values that are near expected values from above during anomaly detection.
         * </p>
         * This is a convenience method that creates an instance of the {@link IgnoreNearExpected.Builder} avoiding the
         * need to create one manually via {@link IgnoreNearExpected#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IgnoreNearExpected.Builder#build()} is called immediately and its
         * result is passed to {@link #ignoreNearExpectedFromAbove(IgnoreNearExpected)}.
         * 
         * @param ignoreNearExpectedFromAbove
         *        a consumer that will call methods on {@link IgnoreNearExpected.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ignoreNearExpectedFromAbove(IgnoreNearExpected)
         */
        default Builder ignoreNearExpectedFromAbove(Consumer<IgnoreNearExpected.Builder> ignoreNearExpectedFromAbove) {
            return ignoreNearExpectedFromAbove(IgnoreNearExpected.builder().applyMutation(ignoreNearExpectedFromAbove).build());
        }

        /**
         * <p>
         * Configuration for ignoring values that are near expected values from below during anomaly detection.
         * </p>
         * 
         * @param ignoreNearExpectedFromBelow
         *        Configuration for ignoring values that are near expected values from below during anomaly detection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ignoreNearExpectedFromBelow(IgnoreNearExpected ignoreNearExpectedFromBelow);

        /**
         * <p>
         * Configuration for ignoring values that are near expected values from below during anomaly detection.
         * </p>
         * This is a convenience method that creates an instance of the {@link IgnoreNearExpected.Builder} avoiding the
         * need to create one manually via {@link IgnoreNearExpected#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IgnoreNearExpected.Builder#build()} is called immediately and its
         * result is passed to {@link #ignoreNearExpectedFromBelow(IgnoreNearExpected)}.
         * 
         * @param ignoreNearExpectedFromBelow
         *        a consumer that will call methods on {@link IgnoreNearExpected.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ignoreNearExpectedFromBelow(IgnoreNearExpected)
         */
        default Builder ignoreNearExpectedFromBelow(Consumer<IgnoreNearExpected.Builder> ignoreNearExpectedFromBelow) {
            return ignoreNearExpectedFromBelow(IgnoreNearExpected.builder().applyMutation(ignoreNearExpectedFromBelow).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String query;

        private Integer shingleSize;

        private Integer sampleSize;

        private IgnoreNearExpected ignoreNearExpectedFromAbove;

        private IgnoreNearExpected ignoreNearExpectedFromBelow;

        private BuilderImpl() {
        }

        private BuilderImpl(RandomCutForestConfiguration model) {
            query(model.query);
            shingleSize(model.shingleSize);
            sampleSize(model.sampleSize);
            ignoreNearExpectedFromAbove(model.ignoreNearExpectedFromAbove);
            ignoreNearExpectedFromBelow(model.ignoreNearExpectedFromBelow);
        }

        public final String getQuery() {
            return query;
        }

        public final void setQuery(String query) {
            this.query = query;
        }

        @Override
        public final Builder query(String query) {
            this.query = query;
            return this;
        }

        public final Integer getShingleSize() {
            return shingleSize;
        }

        public final void setShingleSize(Integer shingleSize) {
            this.shingleSize = shingleSize;
        }

        @Override
        public final Builder shingleSize(Integer shingleSize) {
            this.shingleSize = shingleSize;
            return this;
        }

        public final Integer getSampleSize() {
            return sampleSize;
        }

        public final void setSampleSize(Integer sampleSize) {
            this.sampleSize = sampleSize;
        }

        @Override
        public final Builder sampleSize(Integer sampleSize) {
            this.sampleSize = sampleSize;
            return this;
        }

        public final IgnoreNearExpected.Builder getIgnoreNearExpectedFromAbove() {
            return ignoreNearExpectedFromAbove != null ? ignoreNearExpectedFromAbove.toBuilder() : null;
        }

        public final void setIgnoreNearExpectedFromAbove(IgnoreNearExpected.BuilderImpl ignoreNearExpectedFromAbove) {
            this.ignoreNearExpectedFromAbove = ignoreNearExpectedFromAbove != null ? ignoreNearExpectedFromAbove.build() : null;
        }

        @Override
        public final Builder ignoreNearExpectedFromAbove(IgnoreNearExpected ignoreNearExpectedFromAbove) {
            this.ignoreNearExpectedFromAbove = ignoreNearExpectedFromAbove;
            return this;
        }

        public final IgnoreNearExpected.Builder getIgnoreNearExpectedFromBelow() {
            return ignoreNearExpectedFromBelow != null ? ignoreNearExpectedFromBelow.toBuilder() : null;
        }

        public final void setIgnoreNearExpectedFromBelow(IgnoreNearExpected.BuilderImpl ignoreNearExpectedFromBelow) {
            this.ignoreNearExpectedFromBelow = ignoreNearExpectedFromBelow != null ? ignoreNearExpectedFromBelow.build() : null;
        }

        @Override
        public final Builder ignoreNearExpectedFromBelow(IgnoreNearExpected ignoreNearExpectedFromBelow) {
            this.ignoreNearExpectedFromBelow = ignoreNearExpectedFromBelow;
            return this;
        }

        @Override
        public RandomCutForestConfiguration build() {
            return new RandomCutForestConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
