/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amp.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Filtering criteria that determine which queries are logged.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LoggingFilter implements SdkPojo, Serializable, ToCopyableBuilder<LoggingFilter.Builder, LoggingFilter> {
    private static final SdkField<Long> QSP_THRESHOLD_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("qspThreshold").getter(getter(LoggingFilter::qspThreshold)).setter(setter(Builder::qspThreshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("qspThreshold").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QSP_THRESHOLD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long qspThreshold;

    private LoggingFilter(BuilderImpl builder) {
        this.qspThreshold = builder.qspThreshold;
    }

    /**
     * <p>
     * The Query Samples Processed (QSP) threshold above which queries will be logged. Queries processing more samples
     * than this threshold will be captured in logs.
     * </p>
     * 
     * @return The Query Samples Processed (QSP) threshold above which queries will be logged. Queries processing more
     *         samples than this threshold will be captured in logs.
     */
    public final Long qspThreshold() {
        return qspThreshold;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(qspThreshold());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoggingFilter)) {
            return false;
        }
        LoggingFilter other = (LoggingFilter) obj;
        return Objects.equals(qspThreshold(), other.qspThreshold());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LoggingFilter").add("QspThreshold", qspThreshold()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "qspThreshold":
            return Optional.ofNullable(clazz.cast(qspThreshold()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("qspThreshold", QSP_THRESHOLD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LoggingFilter, T> g) {
        return obj -> g.apply((LoggingFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LoggingFilter> {
        /**
         * <p>
         * The Query Samples Processed (QSP) threshold above which queries will be logged. Queries processing more
         * samples than this threshold will be captured in logs.
         * </p>
         * 
         * @param qspThreshold
         *        The Query Samples Processed (QSP) threshold above which queries will be logged. Queries processing
         *        more samples than this threshold will be captured in logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qspThreshold(Long qspThreshold);
    }

    static final class BuilderImpl implements Builder {
        private Long qspThreshold;

        private BuilderImpl() {
        }

        private BuilderImpl(LoggingFilter model) {
            qspThreshold(model.qspThreshold);
        }

        public final Long getQspThreshold() {
            return qspThreshold;
        }

        public final void setQspThreshold(Long qspThreshold) {
            this.qspThreshold = qspThreshold;
        }

        @Override
        public final Builder qspThreshold(Long qspThreshold) {
            this.qspThreshold = qspThreshold;
            return this;
        }

        @Override
        public LoggingFilter build() {
            return new LoggingFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
