/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amp.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>DeleteScraper</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteScraperResponse extends AmpResponse implements
        ToCopyableBuilder<DeleteScraperResponse.Builder, DeleteScraperResponse> {
    private static final SdkField<String> SCRAPER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scraperId").getter(getter(DeleteScraperResponse::scraperId)).setter(setter(Builder::scraperId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scraperId").build()).build();

    private static final SdkField<ScraperStatus> STATUS_FIELD = SdkField.<ScraperStatus> builder(MarshallingType.SDK_POJO)
            .memberName("status").getter(getter(DeleteScraperResponse::status)).setter(setter(Builder::status))
            .constructor(ScraperStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SCRAPER_ID_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String scraperId;

    private final ScraperStatus status;

    private DeleteScraperResponse(BuilderImpl builder) {
        super(builder);
        this.scraperId = builder.scraperId;
        this.status = builder.status;
    }

    /**
     * <p>
     * The ID of the scraper to delete.
     * </p>
     * 
     * @return The ID of the scraper to delete.
     */
    public final String scraperId() {
        return scraperId;
    }

    /**
     * <p>
     * The current status of the scraper.
     * </p>
     * 
     * @return The current status of the scraper.
     */
    public final ScraperStatus status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(scraperId());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteScraperResponse)) {
            return false;
        }
        DeleteScraperResponse other = (DeleteScraperResponse) obj;
        return Objects.equals(scraperId(), other.scraperId()) && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteScraperResponse").add("ScraperId", scraperId()).add("Status", status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "scraperId":
            return Optional.ofNullable(clazz.cast(scraperId()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("scraperId", SCRAPER_ID_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteScraperResponse, T> g) {
        return obj -> g.apply((DeleteScraperResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AmpResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeleteScraperResponse> {
        /**
         * <p>
         * The ID of the scraper to delete.
         * </p>
         * 
         * @param scraperId
         *        The ID of the scraper to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scraperId(String scraperId);

        /**
         * <p>
         * The current status of the scraper.
         * </p>
         * 
         * @param status
         *        The current status of the scraper.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(ScraperStatus status);

        /**
         * <p>
         * The current status of the scraper.
         * </p>
         * This is a convenience method that creates an instance of the {@link ScraperStatus.Builder} avoiding the need
         * to create one manually via {@link ScraperStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScraperStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #status(ScraperStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link ScraperStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(ScraperStatus)
         */
        default Builder status(Consumer<ScraperStatus.Builder> status) {
            return status(ScraperStatus.builder().applyMutation(status).build());
        }
    }

    static final class BuilderImpl extends AmpResponse.BuilderImpl implements Builder {
        private String scraperId;

        private ScraperStatus status;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteScraperResponse model) {
            super(model);
            scraperId(model.scraperId);
            status(model.status);
        }

        public final String getScraperId() {
            return scraperId;
        }

        public final void setScraperId(String scraperId) {
            this.scraperId = scraperId;
        }

        @Override
        public final Builder scraperId(String scraperId) {
            this.scraperId = scraperId;
            return this;
        }

        public final ScraperStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        public final void setStatus(ScraperStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(ScraperStatus status) {
            this.status = status;
            return this;
        }

        @Override
        public DeleteScraperResponse build() {
            return new DeleteScraperResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
