/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amp.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.amp.model.Destination;
import software.amazon.awssdk.services.amp.model.ScraperStatus;
import software.amazon.awssdk.services.amp.model.Source;
import software.amazon.awssdk.services.amp.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScraperSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ScraperSummary> {
    private static final SdkField<String> ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("alias").getter(ScraperSummary.getter(ScraperSummary::alias)).setter(ScraperSummary.setter(Builder::alias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alias").build()}).build();
    private static final SdkField<String> SCRAPER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scraperId").getter(ScraperSummary.getter(ScraperSummary::scraperId)).setter(ScraperSummary.setter(Builder::scraperId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scraperId").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(ScraperSummary.getter(ScraperSummary::arn)).setter(ScraperSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(ScraperSummary.getter(ScraperSummary::roleArn)).setter(ScraperSummary.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<ScraperStatus> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("status").getter(ScraperSummary.getter(ScraperSummary::status)).setter(ScraperSummary.setter(Builder::status)).constructor(ScraperStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(ScraperSummary.getter(ScraperSummary::createdAt)).setter(ScraperSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastModifiedAt").getter(ScraperSummary.getter(ScraperSummary::lastModifiedAt)).setter(ScraperSummary.setter(Builder::lastModifiedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedAt").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(ScraperSummary.getter(ScraperSummary::tags)).setter(ScraperSummary.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusReason").getter(ScraperSummary.getter(ScraperSummary::statusReason)).setter(ScraperSummary.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()}).build();
    private static final SdkField<Source> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("source").getter(ScraperSummary.getter(ScraperSummary::source)).setter(ScraperSummary.setter(Builder::source)).constructor(Source::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()}).build();
    private static final SdkField<Destination> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("destination").getter(ScraperSummary.getter(ScraperSummary::destination)).setter(ScraperSummary.setter(Builder::destination)).constructor(Destination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALIAS_FIELD, SCRAPER_ID_FIELD, ARN_FIELD, ROLE_ARN_FIELD, STATUS_FIELD, CREATED_AT_FIELD, LAST_MODIFIED_AT_FIELD, TAGS_FIELD, STATUS_REASON_FIELD, SOURCE_FIELD, DESTINATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String alias;
    private final String scraperId;
    private final String arn;
    private final String roleArn;
    private final ScraperStatus status;
    private final Instant createdAt;
    private final Instant lastModifiedAt;
    private final Map<String, String> tags;
    private final String statusReason;
    private final Source source;
    private final Destination destination;

    private ScraperSummary(BuilderImpl builder) {
        this.alias = builder.alias;
        this.scraperId = builder.scraperId;
        this.arn = builder.arn;
        this.roleArn = builder.roleArn;
        this.status = builder.status;
        this.createdAt = builder.createdAt;
        this.lastModifiedAt = builder.lastModifiedAt;
        this.tags = builder.tags;
        this.statusReason = builder.statusReason;
        this.source = builder.source;
        this.destination = builder.destination;
    }

    public final String alias() {
        return this.alias;
    }

    public final String scraperId() {
        return this.scraperId;
    }

    public final String arn() {
        return this.arn;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final ScraperStatus status() {
        return this.status;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant lastModifiedAt() {
        return this.lastModifiedAt;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final Source source() {
        return this.source;
    }

    public final Destination destination() {
        return this.destination;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.alias());
        hashCode = 31 * hashCode + Objects.hashCode(this.scraperId());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScraperSummary)) {
            return false;
        }
        ScraperSummary other = (ScraperSummary)obj;
        return Objects.equals(this.alias(), other.alias()) && Objects.equals(this.scraperId(), other.scraperId()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.lastModifiedAt(), other.lastModifiedAt()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.source(), other.source()) && Objects.equals(this.destination(), other.destination());
    }

    public final String toString() {
        return ToString.builder((String)"ScraperSummary").add("Alias", (Object)this.alias()).add("ScraperId", (Object)this.scraperId()).add("Arn", (Object)this.arn()).add("RoleArn", (Object)this.roleArn()).add("Status", (Object)this.status()).add("CreatedAt", (Object)this.createdAt()).add("LastModifiedAt", (Object)this.lastModifiedAt()).add("Tags", this.hasTags() ? this.tags() : null).add("StatusReason", (Object)this.statusReason()).add("Source", (Object)this.source()).add("Destination", (Object)this.destination()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "alias": {
                return Optional.ofNullable(clazz.cast(this.alias()));
            }
            case "scraperId": {
                return Optional.ofNullable(clazz.cast(this.scraperId()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "lastModifiedAt": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedAt()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "statusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScraperSummary, T> g) {
        return obj -> g.apply((ScraperSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String alias;
        private String scraperId;
        private String arn;
        private String roleArn;
        private ScraperStatus status;
        private Instant createdAt;
        private Instant lastModifiedAt;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String statusReason;
        private Source source;
        private Destination destination;

        private BuilderImpl() {
        }

        private BuilderImpl(ScraperSummary model) {
            this.alias(model.alias);
            this.scraperId(model.scraperId);
            this.arn(model.arn);
            this.roleArn(model.roleArn);
            this.status(model.status);
            this.createdAt(model.createdAt);
            this.lastModifiedAt(model.lastModifiedAt);
            this.tags(model.tags);
            this.statusReason(model.statusReason);
            this.source(model.source);
            this.destination(model.destination);
        }

        public final String getAlias() {
            return this.alias;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public final String getScraperId() {
            return this.scraperId;
        }

        public final void setScraperId(String scraperId) {
            this.scraperId = scraperId;
        }

        @Override
        public final Builder scraperId(String scraperId) {
            this.scraperId = scraperId;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final ScraperStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        public final void setStatus(ScraperStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(ScraperStatus status) {
            this.status = status;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastModifiedAt() {
            return this.lastModifiedAt;
        }

        public final void setLastModifiedAt(Instant lastModifiedAt) {
            this.lastModifiedAt = lastModifiedAt;
        }

        @Override
        public final Builder lastModifiedAt(Instant lastModifiedAt) {
            this.lastModifiedAt = lastModifiedAt;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final Source.Builder getSource() {
            return this.source != null ? this.source.toBuilder() : null;
        }

        public final void setSource(Source.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(Source source) {
            this.source = source;
            return this;
        }

        public final Destination.Builder getDestination() {
            return this.destination != null ? this.destination.toBuilder() : null;
        }

        public final void setDestination(Destination.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        @Override
        public final Builder destination(Destination destination) {
            this.destination = destination;
            return this;
        }

        public ScraperSummary build() {
            return new ScraperSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ScraperSummary> {
        public Builder alias(String var1);

        public Builder scraperId(String var1);

        public Builder arn(String var1);

        public Builder roleArn(String var1);

        public Builder status(ScraperStatus var1);

        default public Builder status(Consumer<ScraperStatus.Builder> status) {
            return this.status((ScraperStatus)((ScraperStatus.Builder)ScraperStatus.builder().applyMutation(status)).build());
        }

        public Builder createdAt(Instant var1);

        public Builder lastModifiedAt(Instant var1);

        public Builder tags(Map<String, String> var1);

        public Builder statusReason(String var1);

        public Builder source(Source var1);

        default public Builder source(Consumer<Source.Builder> source) {
            return this.source((Source)((Source.Builder)Source.builder().applyMutation(source)).build());
        }

        public Builder destination(Destination var1);

        default public Builder destination(Consumer<Destination.Builder> destination) {
            return this.destination((Destination)((Destination.Builder)Destination.builder().applyMutation(destination)).build());
        }
    }
}

